/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.contracts;

import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfContractsPathReferenceProvider
extends PathReferenceProviderBase {
    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jsf/references/contracts/JsfContractsPathReferenceProvider", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/jsf/references/contracts/JsfContractsPathReferenceProvider", "createReferences"));
        }
        if (!JsfCommonUtils.isJsfSupported(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement))) {
            return false;
        }
        FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, true, null){

            protected boolean isUrlEncoded() {
                return true;
            }

            protected boolean isSoft() {
                return true;
            }

            @NotNull
            public Collection<PsiFileSystemItem> getDefaultContexts() {
                HashSet directories = new HashSet();
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                if (module != null) {
                    directories.addAll(JsfCommonUtils.getContractsDirectories(module));
                }
                HashSet hashSet = directories;
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/contracts/JsfContractsPathReferenceProvider$1", "getDefaultContexts"));
                }
                return hashSet;
            }
        };
        Collections.addAll(references, set.getAllReferences());
        return false;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/jsf/references/contracts/JsfContractsPathReferenceProvider", "getPathReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/contracts/JsfContractsPathReferenceProvider", "getPathReference"));
        }
        return null;
    }
}

