/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.AbstractP4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;

public class P4ParametersConnection
extends AbstractP4Connection {
    private final P4ConnectionParameters myParameters;
    private final ConnectionId myConnectionId;
    private final File myCwd;

    public P4ParametersConnection(P4ConnectionParameters parameters, @NotNull ConnectionId connectionId) {
        if (connectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionId", "org/jetbrains/idea/perforce/perforce/connections/P4ParametersConnection", "<init>"));
        }
        this.myParameters = parameters;
        this.myConnectionId = connectionId;
        this.myCwd = this.myConnectionId.myWorkingDir == null ? new File(".") : new File(this.myConnectionId.myWorkingDir);
    }

    @Override
    public void runP4Command(PerforcePhysicalConnectionParametersI parameters, String[] p4args, ExecResult retVal, @Nullable StringBuffer inputStream) throws VcsException, PerforceTimeoutException, IOException, InterruptedException {
        this.runP4CommandImpl(parameters, ArrayUtil.EMPTY_STRING_ARRAY, p4args, retVal, inputStream, this.myCwd);
    }

    @Override
    @NotNull
    public ConnectionKey getConnectionKey() {
        ConnectionKey connectionKey = new ConnectionKey(StringUtil.notNullize((String)this.myParameters.getServer()), StringUtil.notNullize((String)this.myParameters.getClient()), StringUtil.notNullize((String)this.myParameters.getUser()));
        if (connectionKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/connections/P4ParametersConnection", "getConnectionKey"));
        }
        return connectionKey;
    }

    @Override
    public ConnectionId getId() {
        return this.myConnectionId;
    }

    @Override
    public boolean handlesFile(File file) {
        return !this.myConnectionId.myUseP4Config || FileUtil.isAncestor((File)this.myCwd, (File)file, (boolean)false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        P4ParametersConnection that = (P4ParametersConnection)o;
        return this.myConnectionId.equals(that.myConnectionId);
    }

    public int hashCode() {
        return this.myConnectionId.hashCode();
    }

    public P4ConnectionParameters getParameters() {
        return this.myParameters;
    }

    public String toString() {
        return "P4ParametersConnection{" + this.myParameters + '}' + System.identityHashCode(this);
    }
}

