/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeEvent;

public abstract class PsiConfigManagerBase<P extends PsiFile, C extends DMFacetConfigurationBase<C>, F extends DMFacetBase<C>> {
    public void onPsiEvent(PsiTreeChangeEvent event, F facet2update) {
        P configFile = this.findConfigFile(facet2update.getModule());
        if (configFile == null) {
            return;
        }
        PsiFile changedFile = event.getFile();
        if (changedFile == null) {
            return;
        }
        if (!Comparing.equal((Object)configFile.getVirtualFile(), (Object)changedFile.getVirtualFile())) {
            return;
        }
        if (this.onConfigFileChanged(((DMFacetBase)((Object)facet2update)).getConfigurationImpl(), configFile)) {
            ((DMFacetBase)((Object)facet2update)).getCommonPart().fireFacetChanged();
        }
    }

    protected abstract P findConfigFile(Module var1);

    protected abstract boolean onConfigFileChanged(C var1, P var2);

    protected static <T> T safeValue(T value, T ifNull) {
        return value == null ? ifNull : value;
    }
}

