/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.util.PathUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class PathResolver {
    public String path2Absolute(String path) {
        return FileUtil.isAbsolute((String)FileUtil.toSystemDependentName((String)path)) ? path : PathUtils.concatPaths(this.getBaseDir().getPath(), path);
    }

    public String path2Relative(String path) {
        String relativePath;
        String independentPath = FileUtil.toSystemIndependentName((String)path);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(independentPath);
        if (file != null && VfsUtil.isAncestor((VirtualFile)this.getBaseDir(), (VirtualFile)file, (boolean)true) && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.getBaseDir(), (char)'/')) != null) {
            return relativePath;
        }
        return independentPath;
    }

    protected abstract VirtualFile getBaseDir();
}

