/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class ModuleUtils {
    public static VirtualFile getModuleRoot(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/util/ModuleUtils", "getModuleRoot"));
        }
        VirtualFile[] contentRoots = rootModel.getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        return contentRoots[0];
    }

    public static VirtualFile getModuleRoot(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/util/ModuleUtils", "getModuleRoot"));
        }
        return ModuleUtils.getModuleRoot((ModuleRootModel)ModuleRootManager.getInstance((Module)module));
    }
}

