/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetaModel<T>
implements Comparator<ObjectKind> {
    private final Map<Couple<ObjectKind>, Class> objectClasses;
    private final Map<String, ObjectKind> objectKinds;
    private final Set<ObjectKind> namespaces;
    private final MultiMap<ObjectKind, List<ObjectKind>> paths;

    @NotNull
    public static <T> MetaModelBuilder<T> builder() {
        MetaModelBuilder metaModelBuilder = new MetaModelBuilder();
        if (metaModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "builder"));
        }
        return metaModelBuilder;
    }

    private MetaModel(@NotNull Map<Couple<ObjectKind>, Class> objectClasses, @NotNull Map<String, ObjectKind> objectKinds) {
        if (objectClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClasses", "com/intellij/database/model/MetaModel", "<init>"));
        }
        if (objectKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKinds", "com/intellij/database/model/MetaModel", "<init>"));
        }
        this.paths = MultiMap.createLinkedSet();
        this.objectClasses = objectClasses;
        this.objectKinds = objectKinds;
        this.namespaces = Collections.unmodifiableSet((Set)JBIterable.from(objectClasses.keySet()).filter(Conditions.compose((Function)Functions.fromMap(objectClasses), (Condition)Conditions.assignableTo(DasNamespace.class))).transform(Functions.pairSecond()).addAllTo((Collection)ContainerUtil.newLinkedHashSet()));
        LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
        JBIterable traversal = ((JBTreeTraverser)new JBTreeTraverser(this::getChildKinds).withRoot((Object)ObjectKind.ROOT)).traverse(TreeTraversal.INTERLEAVED_DFS);
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)traversal.typedIterator();
        while (it.hasNext()) {
            ObjectKind next = (ObjectKind)it.next();
            List list = it.backtrace().toList();
            if (list.size() <= objectKinds.size()) {
                this.paths.putValue((Object)next, (Object)ContainerUtil.newUnmodifiableList((List)list));
            }
            visited.add(next);
            if (visited.size() != objectKinds.size()) continue;
            break;
        }
    }

    public Class<? extends T> getObjectClass(ObjectKind parent, ObjectKind child) {
        return this.objectClasses.get(Couple.of((Object)parent, (Object)child));
    }

    public Class<? extends T> getObjectClass(Couple<ObjectKind> couple) {
        return this.objectClasses.get(couple);
    }

    @NotNull
    public Set<Couple<ObjectKind>> getKindCouples() {
        Set<Couple<ObjectKind>> set = this.objectClasses.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getKindCouples"));
        }
        return set;
    }

    @NotNull
    public Iterable<ObjectKind> getKinds() {
        Collection<ObjectKind> collection = this.objectKinds.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getKinds"));
        }
        return collection;
    }

    @NotNull
    public JBIterable<ObjectKind> getRootNamespaceKinds() {
        JBIterable<ObjectKind> jBIterable = this.getChildKinds(ObjectKind.ROOT);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getRootNamespaceKinds"));
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getChildKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/MetaModel", "getChildKinds"));
        }
        JBIterable jBIterable = JBIterable.from(this.getKindCouples()).filter(Conditions.compose((Function)Functions.pairFirst(), (Condition)Conditions.is((Object)kind))).transform(Functions.pairSecond());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getChildKinds"));
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getParentKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/MetaModel", "getParentKinds"));
        }
        JBIterable jBIterable = JBIterable.from(this.getKindCouples()).filter(Conditions.compose((Function)Functions.pairSecond(), (Condition)Conditions.is((Object)kind))).transform(Functions.pairFirst());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getParentKinds"));
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getNamespaces() {
        Set<ObjectKind> set = this.namespaces;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getNamespaces"));
        }
        return set;
    }

    @NotNull
    public JBIterable<List<ObjectKind>> getPathsToRoot(ObjectKind kind) {
        if (!this.paths.containsKey((Object)kind)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getPathsToRoot"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)this.paths.get((Object)kind));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/MetaModel", "getPathsToRoot"));
        }
        return jBIterable;
    }

    @Nullable
    public ObjectKind findKind(@Nullable String code) {
        if (code == null) {
            return null;
        }
        if ((code = code.trim()).isEmpty()) {
            return null;
        }
        return this.objectKinds.get(code);
    }

    @Override
    public int compare(ObjectKind o1, ObjectKind o2) {
        if (o1 == o2) {
            return 0;
        }
        for (ObjectKind t : this.objectKinds.values()) {
            if (o1 == t) {
                return -1;
            }
            if (o2 != t) continue;
            return 1;
        }
        throw new AssertionError((Object)(o1 + " and " + o2 + " not found in " + this));
    }

    public String toString() {
        return this.objectKinds.values().toString();
    }

    public static final class MetaModelBuilder<T> {
        private final Map<Couple<ObjectKind>, Class> a = ContainerUtil.newLinkedHashMap();
        private final Map<String, ObjectKind> b = ContainerUtil.newLinkedHashMap();

        public MetaModelBuilder() {
            this.b.put("root", ObjectKind.ROOT);
        }

        public MetaModelBuilder<T> put(ObjectKind parent, ObjectKind child, Class<? extends T> childClass) {
            this.a.put((Couple<ObjectKind>)Couple.of((Object)parent, (Object)child), childClass);
            this.b.put(child.code(), child);
            return this;
        }

        public MetaModel<T> build() {
            return new MetaModel(Collections.unmodifiableMap(this.a), Collections.unmodifiableMap(this.b));
        }
    }
}

