/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import icons.GroovyMvcIcons;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettings;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class GrailsModuleStructureUtil {
    private static final Logger LOG = Logger.getInstance(GrailsModuleStructureUtil.class);
    @NonNls
    private static final String INPLACE_PLUGINS_MODULE_SUFFIX = "-inplacePlugin";
    @NonNls
    private static final String INPLACE_PLUGINS_MODULE_INFIX_OLD = "-grailsPlugin-";
    @NonNls
    public static final String GRAILS_VERSION_KEY = "app.grails.version";
    @NonNls
    static final String UPGRADE_COMMAND = "upgrade";
    @NonNls
    static final String UPGRADE_COMMAND_2_4_x = "set-grails-version";
    @NonNls
    static final String YES = "y\n";
    @NonNls
    static final String YESx2 = "y\ny\n";

    private GrailsModuleStructureUtil() {
    }

    public static Set<Module> getAllCustomPluginModules(Module module) {
        HashSet<Module> res = new HashSet<Module>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        GrailsModuleStructureUtil.collectCustomPluginModules(module, res, fileIndex);
        res.remove(module);
        return res;
    }

    private static void collectCustomPluginModules(Module module, Set<Module> result, ProjectFileIndex fileIndex) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!result.add(module)) {
            return;
        }
        Map<String, VirtualFile> locations = GrailsFramework.getCustomPluginLocations(module, true);
        for (VirtualFile virtualFile : locations.values()) {
            Module candidate = fileIndex.getModuleForFile(virtualFile);
            if (candidate == null || !Comparing.equal((Object)fileIndex.getContentRootForFile(virtualFile), (Object)virtualFile) || !GrailsFramework.getInstance().hasSupport(module)) continue;
            GrailsModuleStructureUtil.collectCustomPluginModules(candidate, result, fileIndex);
        }
    }

    public static void upgradeGrails(@NotNull Module module, boolean force) {
        int resultValue;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleStructureUtil", "upgradeGrails"));
        }
        OldGrailsApplication grailsApplication2 = GrailsApplicationManager.findApplication(module);
        if (!(grailsApplication2 instanceof Grails2Application)) {
            if (grailsApplication2 == null && force) {
                throw new IllegalStateException("Should not get here");
            }
            return;
        }
        GrailsSDK grailsSdk = GrailsSDKManager.getGrailsSdk(grailsApplication2);
        if (grailsSdk == null) {
            return;
        }
        GrailsSettings grailsSettings = GrailsSettingsService.getGrailsSettings(module);
        Version sdkVersion = grailsSdk.getVersion();
        Version appPropertiesVersion = ((Grails2Application)grailsApplication2).getApplicationPropertiesVersion();
        if (appPropertiesVersion != null && (appPropertiesVersion.equals(sdkVersion) || !force && appPropertiesVersion.equalsToString(grailsSettings.fixedGrailsVersion))) {
            return;
        }
        boolean ask = !force && grailsApplication2.getUserData(MvcFramework.UPGRADE) != Boolean.TRUE && appPropertiesVersion != null;
        grailsApplication2.putUserData(MvcFramework.UPGRADE, null);
        if (ask && (resultValue = Messages.showDialog((String)GrailsBundle.message("grails.malformed.version", appPropertiesVersion, sdkVersion, grailsApplication2.getName()), (String)GrailsBundle.message("grails.upgrade.app", new Object[0]), (String[])new String[]{"Yes, upgrade", "Not now", "No, don't ask for this version (" + appPropertiesVersion + ")"}, (int)0, (Icon)GroovyMvcIcons.Grails_module)) != 0) {
            if (resultValue == 2) {
                grailsSettings.fixedGrailsVersion = String.valueOf(appPropertiesVersion);
            }
            return;
        }
        try {
            MvcCommand command = sdkVersion.compareTo(Version.GRAILS_2_4_0) >= 0 ? new MvcCommand(UPGRADE_COMMAND_2_4_x, new String[]{String.valueOf(sdkVersion)}) : new MvcCommand(UPGRADE_COMMAND, new String[0]);
            GeneralCommandLine commandLine = GrailsCommandExecutorUtil.createCommandLine(grailsApplication2, command);
            ApplicationManager.getApplication().invokeLater(() -> GrailsConsole.executeProcess(grailsApplication2.getProject(), commandLine, null, true, YESx2));
        }
        catch (ExecutionException e) {
            GrailsConsole.NOTIFICATION_GROUP.createNotification("Failed to execute Grails command", e.getMessage(), NotificationType.ERROR, null);
            LOG.info((Throwable)e);
        }
    }

    public static boolean isIdeaGeneratedCustomPluginModule(Module pluginModule) {
        String name = pluginModule.getName();
        return name.endsWith(INPLACE_PLUGINS_MODULE_SUFFIX) || name.contains(INPLACE_PLUGINS_MODULE_INFIX_OLD);
    }

    public static String generateInplacePluginModuleName(String pluginName) {
        return pluginName + INPLACE_PLUGINS_MODULE_SUFFIX;
    }

    public static boolean isInplacePluginModuleName(@NotNull String pluginName) {
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "org/jetbrains/plugins/grails/config/GrailsModuleStructureUtil", "isInplacePluginModuleName"));
        }
        return pluginName.endsWith(INPLACE_PLUGINS_MODULE_SUFFIX);
    }
}

