/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.Grails3TraitInjectorContributor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class Gorm5TraitContributor
implements AstTransformationSupport {
    public void applyTransformation(@NotNull TransformationContext context) {
        Optional<PsiClass> candidate;
        List<PsiClass> providers;
        boolean hibernatePresent;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "applyTransformation"));
        }
        GrTypeDefinition clazz = context.getCodeClass();
        if (GrailsUtils.calculateArtifactType((PsiClass)clazz) != GrailsArtifact.DOMAIN) {
            return;
        }
        if (GormUtils.getGormVersion((PsiElement)clazz) != GormUtils.GormVersion.AT_LEAST_5) {
            return;
        }
        String mapWith = Gorm5TraitContributor.computeMapWithValue(clazz);
        boolean bl = hibernatePresent = JavaPsiFacade.getInstance((Project)clazz.getProject()).findClass("org.hibernate.Hibernate", clazz.getResolveScope()) != null;
        String traitFqn = hibernatePresent && mapWith == null ? "org.grails.datastore.gorm.GormEntity" : ((providers = Gorm5TraitContributor.findTraitProviders((PsiElement)clazz)).isEmpty() ? "org.grails.datastore.gorm.GormEntity" : (StringUtil.isEmpty((String)mapWith) ? (providers.size() == 1 ? providers.get(0).getQualifiedName() : "org.grails.datastore.gorm.GormEntity") : ((candidate = providers.stream().filter(p -> p.getName() != null && p.getName().startsWith(mapWith)).findFirst()).isPresent() ? candidate.get().getQualifiedName() : "org.grails.datastore.gorm.GormEntity")));
        Grails3TraitInjectorContributor.injectTraits(clazz, context, ContainerUtil.newArrayList((Object[])new String[]{traitFqn}));
    }

    @Nullable
    private static String computeMapWithValue(@NotNull GrTypeDefinition clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "computeMapWithValue"));
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)clazz, () -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "lambda$computeMapWithValue$1"));
            }
            return CachedValueProvider.Result.create((Object)Gorm5TraitContributor.doComputeMapWithValue(clazz), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static String doComputeMapWithValue(@NotNull GrTypeDefinition clazz) {
        Object value;
        GrExpression initializer;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "doComputeMapWithValue"));
        }
        PsiField mapWith = clazz.findCodeFieldByName("mapWith", true);
        if (mapWith instanceof GrField && (initializer = ((GrField)mapWith).getInitializerGroovy()) instanceof GrLiteral && (value = ((GrLiteral)initializer).getValue()) instanceof String) {
            return StringUtil.capitalize((String)((String)value));
        }
        return null;
    }

    @NotNull
    private static List<PsiClass> findTraitProviders(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "findTraitProviders"));
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)context, () -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "lambda$findTraitProviders$2"));
            }
            return CachedValueProvider.Result.create(Gorm5TraitContributor.doFindTraitProviders(context), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "findTraitProviders"));
        }
        return list;
    }

    @NotNull
    private static List<PsiClass> doFindTraitProviders(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "doFindTraitProviders"));
        }
        Project project = context.getProject();
        GlobalSearchScope scope2 = context.getResolveScope();
        PsiClass gormEntity = JavaPsiFacade.getInstance((Project)project).findClass("org.grails.datastore.gorm.GormEntity", scope2);
        if (gormEntity == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "doFindTraitProviders"));
            }
            return list;
        }
        THashSet result = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiClass>(){

            public int computeHashCode(PsiClass object) {
                String fqn = object.getQualifiedName();
                return fqn == null ? 0 : fqn.hashCode();
            }

            public boolean equals(PsiClass o1, PsiClass o2) {
                return Comparing.equal((String)o1.getQualifiedName(), (String)o2.getQualifiedName());
            }
        });
        for (PsiClass psiClass : ClassInheritorsSearch.search((PsiClass)gormEntity)) {
            if (!GrTraitUtil.isTrait((PsiClass)psiClass)) continue;
            result.add(psiClass);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)result);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/Gorm5TraitContributor", "doFindTraitProviders"));
        }
        return arrayList;
    }
}

