/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspGrailsTag;

public class GspFoldingBuilder
implements FoldingBuilder,
GspElementTypes,
DumbAware {
    private static final TokenSet GSP_TAGS = TokenSet.create((IElementType[])new IElementType[]{GSP_SCRIPTLET_TAG, GSP_DIRECTIVE, GSP_EXPR_TAG, GSP_DECLARATION_TAG});

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/grails/lang/gsp/folding/GspFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/grails/lang/gsp/folding/GspFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        GspFoldingBuilder.appendGspDescriptors(node, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/folding/GspFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private static void appendGspDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        IElementType elementType = node.getElementType();
        if ((elementType == GSP_STYLE_COMMENT || elementType == JSP_STYLE_COMMENT) && GspFoldingBuilder.isMultiline(node)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        if (elementType == GRAILS_TAG) {
            GspFoldingBuilder.appendGrailsTagDescriptors(node, descriptors);
        }
        if (GSP_DIRECTIVE != elementType && GSP_TAGS.contains(elementType) && GspFoldingBuilder.isMultiline(node)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            GspFoldingBuilder.appendGspDescriptors(child, descriptors);
        }
    }

    private static void appendGrailsTagDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        int idOffset;
        int tagEndOffset;
        PsiElement element = node.getPsi();
        if (!(element instanceof GspGrailsTag)) {
            return;
        }
        GspGrailsTag tag = (GspGrailsTag)element;
        if (!GspFoldingBuilder.isMultiline(node) || tag.endsByError()) {
            return;
        }
        int n = tagEndOffset = tag.isEmpty() ? tag.getTextRange().getEndOffset() - 2 : tag.getTextRange().getEndOffset() - 1;
        if (!tag.isValid()) {
            return;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        if (attributes != null && attributes.length > 0) {
            int listEndOffset = attributes[0].getTextRange().getEndOffset();
            if (listEndOffset < tagEndOffset - 1) {
                TextRange range = new TextRange(listEndOffset, tagEndOffset);
                descriptors.add(new FoldingDescriptor(node, range));
            }
            return;
        }
        PsiElement identifier = tag.getNameElement();
        if (identifier != null && (idOffset = identifier.getTextRange().getEndOffset()) < tagEndOffset - 1) {
            TextRange range = new TextRange(idOffset, tagEndOffset);
            descriptors.add(new FoldingDescriptor(node, range));
        }
    }

    private static boolean isMultiline(ASTNode node) {
        return node.getText().contains("\n") || node.getText().contains("\t");
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/grails/lang/gsp/folding/GspFoldingBuilder", "getPlaceholderText"));
        }
        IElementType elemType = node.getElementType();
        if (elemType == JSP_STYLE_COMMENT) {
            return "<%--...--%>";
        }
        if (elemType == GSP_STYLE_COMMENT) {
            return "%{--...--}%";
        }
        if (GRAILS_TAG.equals(elemType)) {
            return "...";
        }
        if (GSP_TAGS.contains(elemType)) {
            ASTNode childNode = node.getFirstChildNode();
            assert (childNode != null);
            if (childNode.getElementType() == GSCRIPT_BEGIN) {
                return "%{...}%";
            }
            if (childNode.getElementType() == GEXPR_BEGIN) {
                return "${...}";
            }
            if (childNode.getElementType() == GDECLAR_BEGIN) {
                return "!{...}!";
            }
            if (childNode.getElementType() == GDIRECT_BEGIN) {
                return "@{...}";
            }
            if (childNode.getElementType() == JSCRIPT_BEGIN) {
                return "<%...%>";
            }
            if (childNode.getElementType() == JEXPR_BEGIN) {
                return "<%=...%>";
            }
            if (childNode.getElementType() == JDECLAR_BEGIN) {
                return "<%!...%>";
            }
            if (childNode.getElementType() == JDIRECT_BEGIN) {
                return "<%@...%>";
            }
            return null;
        }
        PsiElement psi = node.getPsi();
        if (psi instanceof XmlComment) {
            return "...";
        }
        if (psi instanceof XmlTag) {
            return "...";
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/grails/lang/gsp/folding/GspFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

