/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationExtension;
import org.jetbrains.plugins.grails.runner.SetupKt;
import org.jetbrains.plugins.grails.runner.impl.BaseGrailsCommandLineState;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsCommandLineState
extends BaseGrailsCommandLineState {
    @NotNull
    private final GrailsApplication myApplication;
    @NotNull
    private final MvcCommand myCommand;
    @NotNull
    private final GrailsCommandLineExecutor myExecutor;

    public GrailsCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull GrailsRunConfiguration configuration, @NotNull GrailsCommandLineExecutor executor) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "<init>"));
        }
        super(environment, configuration);
        this.myApplication = configuration.getGrailsApplication();
        this.myCommand = configuration.getGrailsCommand();
        this.myExecutor = executor;
    }

    @NotNull
    public GrailsApplication getApplication() {
        GrailsApplication grailsApplication2 = this.myApplication;
        if (grailsApplication2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "getApplication"));
        }
        return grailsApplication2;
    }

    @NotNull
    public MvcCommand getCommand() {
        MvcCommand mvcCommand = this.myCommand;
        if (mvcCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "getCommand"));
        }
        return mvcCommand;
    }

    @NotNull
    public GrailsCommandLineExecutor getExecutor() {
        GrailsCommandLineExecutor grailsCommandLineExecutor = this.myExecutor;
        if (grailsCommandLineExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "getExecutor"));
        }
        return grailsCommandLineExecutor;
    }

    @NotNull
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters parameters = this.doCreateJavaParameters();
        parameters.setWorkingDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)this.getApplication().getRoot()));
        if (parameters.getJdk() == null) {
            Sdk sdk = ProjectRootManager.getInstance((Project)this.getEnvironment().getProject()).getProjectSdk();
            parameters.setJdk(sdk);
        }
        parameters.setEnv((Map)ContainerUtil.newHashMap((Map)this.myCommand.getEnvVariables()));
        parameters.setPassParentEnvs(this.myCommand.isPassParentEnvs());
        if (DefaultDebugExecutor.getDebugExecutorInstance().equals(this.getEnvironment().getExecutor())) {
            Version version = this.getApplication().getGrailsVersion();
            if (version.isAtLeast(Version.GRAILS_1_3_4) && version.isLessThan(Version.GRAILS_3_0) && !parameters.getEnv().containsKey("GROOVY_PAGE_ADD_LINE_NUMBERS")) {
                parameters.getEnv().put("GROOVY_PAGE_ADD_LINE_NUMBERS", "true");
            }
            if (version.compareTo(Version.GRAILS_2_0) >= 0 && !parameters.getVMParametersList().hasProperty("grails.full.stacktrace")) {
                parameters.getVMParametersList().addProperty("grails.full.stacktrace", "true");
            }
        }
        SetupKt.setupJavaParameters(this.getConfiguration(), this, parameters);
        JavaParameters javaParameters = parameters;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "createJavaParameters"));
        }
        return javaParameters;
    }

    @NotNull
    protected JavaParameters doCreateJavaParameters() throws ExecutionException {
        GrailsCommandLineExecutor executor = this.getExecutor();
        if (executor instanceof GrailsRunConfigurationExtension) {
            GrailsRunConfigurationExtension runConfigurationExtensionExecutor = (GrailsRunConfigurationExtension)((Object)executor);
            Key key = runConfigurationExtensionExecutor.getKey();
            JavaParameters javaParameters = runConfigurationExtensionExecutor.createJavaParameters(this.getApplication(), this.getCommand(), this.getConfiguration().getUserData(key));
            if (javaParameters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "doCreateJavaParameters"));
            }
            return javaParameters;
        }
        JavaParameters javaParameters = executor.createJavaParameters(this.getApplication(), this.getCommand());
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "doCreateJavaParameters"));
        }
        return javaParameters;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ProcessHandler handler;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "execute"));
        }
        ExecutionResult result = super.execute(executor, runner);
        if (this.getConfiguration().isLaunchBrowser() && (handler = result.getProcessHandler()) != null) {
            handler.addProcessListener((ProcessListener)GrailsExecutionUtils.getBrowserLaunchListener(handler));
        }
        ExecutionResult executionResult = result;
        if (executionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/impl/GrailsCommandLineState", "execute"));
        }
        return executionResult;
    }
}

