/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.sync.GrailsApplicationBackgroundTask;
import org.jetbrains.plugins.grails.ui.GrailsConfigureSDKDialog;

public class GrailsSdkCheckTask
extends GrailsApplicationBackgroundTask {
    public GrailsSdkCheckTask(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsSdkCheckTask", "<init>"));
        }
        super(project, "Check Grails SDK");
    }

    @Override
    protected void run(final @NotNull GrailsApplication application, @NotNull ProgressIndicator indicator) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/structure/sync/GrailsSdkCheckTask", "run"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/structure/sync/GrailsSdkCheckTask", "run"));
        }
        GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
        if (executor != null) {
            return;
        }
        String content = GrailsBundle.message("grails.sdk.not.found.content", application.getName());
        Notification notification = new Notification("Grails Configure", GrailsBundle.message("grails.sdk.not.found.title", new Object[0]), content, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/plugins/grails/structure/sync/GrailsSdkCheckTask$1", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/grails/structure/sync/GrailsSdkCheckTask$1", "hyperlinkActivated"));
                }
                new GrailsConfigureSDKDialog(application.getProject()).setGrailsApplication(application).show();
            }
        }).setImportant(true);
        Disposer.register((Disposable)application, () -> ((Notification)notification).expire());
        notification.notify(application.getProject());
    }
}

