/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.plugins.groovy.mvc.plugins.AvailablePluginsModel;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginIsInstalledColumnInfo;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsTable;

public abstract class MvcPluginColumnInfo
extends ColumnInfo<MvcPluginDescriptor, String> {
    private final AvailablePluginsModel myModel;
    private final int myWidth;

    public MvcPluginColumnInfo(AvailablePluginsModel model, String title, int width) {
        super(title);
        this.myModel = model;
        this.myWidth = width;
    }

    public abstract String valueOf(MvcPluginDescriptor var1);

    public Comparator<MvcPluginDescriptor> getComparator() {
        return (o1, o2) -> {
            int result = StringUtil.compare((String)this.valueOf((MvcPluginDescriptor)o1), (String)this.valueOf((MvcPluginDescriptor)o2), (boolean)true);
            if (result != 0) {
                return result;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        };
    }

    public TableCellRenderer getRenderer(MvcPluginDescriptor o) {
        return new MvcPluginCellRenderer(this.myModel);
    }

    public Class getColumnClass() {
        return String.class;
    }

    public int getWidth(JTable table) {
        return this.myWidth;
    }

    private static class MvcPluginCellRenderer
    extends ColoredTableCellRenderer {
        private final AvailablePluginsModel myModel;

        private MvcPluginCellRenderer(AvailablePluginsModel model) {
            this.myModel = model;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            MvcPluginDescriptor mvcPlugin = ((MvcPluginsTable)((Object)table)).getPluginAt(row);
            if (column == 1) {
                this.setIcon(AllIcons.Nodes.Pluginnotinstalled);
                this.appendRenderedText(mvcPlugin, mvcPlugin.getName());
            } else if (column == 3) {
                this.appendRenderedText(mvcPlugin, mvcPlugin.getTitle());
            } else if (column == 2) {
                this.appendRenderedText(mvcPlugin, mvcPlugin.getLatestVersion());
            }
        }

        private void appendRenderedText(MvcPluginDescriptor mvcPlugin, String text) {
            MvcPluginIsInstalledColumnInfo isInstalledColumnInfo;
            if (text == null) {
                text = "";
            }
            if ((isInstalledColumnInfo = (MvcPluginIsInstalledColumnInfo)this.myModel.getColumnInfos()[0]).getToRemovePlugins().contains(mvcPlugin.getName())) {
                SimpleTextAttributes deleteSimpleTextAttributes = new SimpleTextAttributes(0, MvcPluginUtil.COLOR_REMOVE_PLUGIN);
                this.append(text, deleteSimpleTextAttributes);
            } else if (isInstalledColumnInfo.getToInstallPlugins().contains(mvcPlugin.getName())) {
                SimpleTextAttributes installSimpleTextAttributes = new SimpleTextAttributes(0, MvcPluginUtil.COLOR_INSTALL_PLUGIN);
                this.append(text, installSimpleTextAttributes);
            } else {
                this.append(text, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            }
        }
    }
}

