/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.formatter;

import com.intellij.coldFusion.model.formatter.CfmlFormatterUtil;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class CfmlAlignmentProcessor
extends CfmlFormatterUtil {
    private final ASTNode myNode;
    private final Alignment myBaseAlignment;
    private final CommonCodeStyleSettings mySettings;

    public CfmlAlignmentProcessor(ASTNode node, CommonCodeStyleSettings settings) {
        this.myNode = node;
        this.myBaseAlignment = Alignment.createAlignment();
        this.mySettings = settings;
    }

    @Nullable
    Alignment createChildAlignment() {
        IElementType parentType = this.myNode.getElementType();
        if (parentType == CfmlElementTypes.BINARY_EXPRESSION && this.mySettings.ALIGN_MULTILINE_BINARY_OPERATION) {
            return this.myBaseAlignment;
        }
        if (parentType == CfmlElementTypes.TERNARY_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            return this.myBaseAlignment;
        }
        if (parentType == CfmlElementTypes.PARAMETERS_LIST || parentType == CfmlElementTypes.ARGUMENT_LIST) {
            ASTNode boundParent = this.myNode.getTreeParent();
            IElementType boundElType = boundParent.getElementType();
            boolean doAlign = false;
            if (boundElType == CfmlElementTypes.FUNCTION_DEFINITION) {
                doAlign = this.mySettings.ALIGN_MULTILINE_PARAMETERS;
            } else if (boundElType == CfmlElementTypes.FUNCTION_CALL_EXPRESSION) {
                doAlign = this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
            }
            if (doAlign) {
                return this.myBaseAlignment;
            }
        }
        if (parentType == CfmlElementTypes.FOREXPRESSION && this.mySettings.ALIGN_MULTILINE_FOR) {
            return this.myBaseAlignment;
        }
        return null;
    }
}

