/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.info;

import com.intellij.util.ArrayUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class CfmlAttributeDescription
implements Comparable<CfmlAttributeDescription> {
    private Pattern myNamePattern;
    private int myType;
    private boolean myRequired;
    private String myDescription;
    private String myCompletionExample = null;
    private String[] myValues = null;

    public CfmlAttributeDescription(String name, int type, boolean required, String description) {
        this.myNamePattern = Pattern.compile(name);
        this.myType = type;
        this.myRequired = required;
        this.myDescription = description;
    }

    public CfmlAttributeDescription(String name, int type, boolean required, String description, String completionExample) {
        this(name, type, required, description);
        this.myCompletionExample = completionExample;
    }

    public void addValue(String value) {
        if (this.myValues == null) {
            this.myValues = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        this.myValues = (String[])ArrayUtil.append((Object[])this.myValues, (Object)value);
    }

    @Nullable
    public String[] getValues() {
        return this.myValues;
    }

    public String getName() {
        return this.myNamePattern.matcher(this.myNamePattern.pattern()).matches() ? this.myNamePattern.pattern() : this.myCompletionExample;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public boolean acceptName(String name) {
        return this.myNamePattern.matcher(name).matches();
    }

    public int getType() {
        return this.myType;
    }

    public boolean isRequired() {
        return this.myRequired;
    }

    @Override
    public int compareTo(CfmlAttributeDescription o) {
        return this.myNamePattern.pattern().compareTo(o.myNamePattern.pattern());
    }

    public String toString() {
        return "" + this.myNamePattern.pattern() + "</div>" + this.getDescription() + "</div>" + this.getType() + "</div>" + this.isRequired() + "</div>";
    }
}

