/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.parsers;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.lexer.CfmlLexer;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.parsers.CfmlParser;
import com.intellij.coldFusion.model.psi.CfmlCompositeElementType;
import com.intellij.coldFusion.model.psi.impl.CfmlComponentImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagComponentImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class CfmlParserDefinition
implements ParserDefinition {
    private static final TokenSet myCommentTypes = TokenSet.create((IElementType[])new IElementType[]{CfmlTokenTypes.COMMENT, CfscriptTokenTypes.COMMENT, CfmlTokenTypes.VAR_ANNOTATION});

    @NotNull
    public Lexer createLexer(Project project) {
        CfmlLexer cfmlLexer = new CfmlLexer(false, project);
        if (cfmlLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParserDefinition", "createLexer"));
        }
        return cfmlLexer;
    }

    public PsiParser createParser(Project project) {
        return new CfmlParser();
    }

    public IFileElementType getFileNodeType() {
        return CfmlElementTypes.CFML_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{CfmlTokenTypes.WHITE_SPACE, CfscriptTokenTypes.WHITE_SPACE});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = myCommentTypes;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{CfmlTokenTypes.STRING_TEXT, CfmlTokenTypes.SINGLE_QUOTE, CfmlTokenTypes.DOUBLE_QUOTE, CfmlTokenTypes.SINGLE_QUOTE_CLOSER, CfmlTokenTypes.DOUBLE_QUOTE_CLOSER, CfmlTokenTypes.SINGLE_QUOTE, CfmlTokenTypes.SINGLE_QUOTE_CLOSER, CfmlTokenTypes.DOUBLE_QUOTE, CfmlTokenTypes.DOUBLE_QUOTE_CLOSER});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof CfmlCompositeElementType) {
            PsiElement psiElement = ((CfmlCompositeElementType)type).createPsiElement(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (type == CfmlElementTypes.COMPONENT_DEFINITION) {
            CfmlComponentImpl cfmlComponentImpl = new CfmlComponentImpl(node);
            if (cfmlComponentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParserDefinition", "createElement"));
            }
            return cfmlComponentImpl;
        }
        if (type == CfmlElementTypes.COMPONENT_TAG) {
            CfmlTagComponentImpl cfmlTagComponentImpl = new CfmlTagComponentImpl(node);
            if (cfmlTagComponentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParserDefinition", "createElement"));
            }
            return cfmlTagComponentImpl;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new CfmlFile(viewProvider, CfmlLanguage.INSTANCE);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public String toString() {
        return "CfmlParserDefinition";
    }
}

