/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingProcessHandler
extends OSProcessHandler {
    private static final Logger LOG = Logger.getInstance(CapturingProcessHandler.class);
    private final ProcessOutput myOutput;

    public CapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/CapturingProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myOutput = new ProcessOutput();
        this.addProcessListener((ProcessListener)this.createProcessAdapter(this.myOutput));
    }

    @Deprecated
    public CapturingProcessHandler(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/CapturingProcessHandler", "<init>"));
        }
        this(process, null, "");
    }

    @Deprecated
    public CapturingProcessHandler(@NotNull Process process, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/CapturingProcessHandler", "<init>"));
        }
        this(process, charset, "");
    }

    public CapturingProcessHandler(@NotNull Process process, @Nullable Charset charset, String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/CapturingProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myOutput = new ProcessOutput();
        this.addProcessListener((ProcessListener)this.createProcessAdapter(this.myOutput));
    }

    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new CapturingProcessAdapter(processOutput);
    }

    @NotNull
    public ProcessOutput runProcess() {
        this.startNotify();
        if (this.waitFor()) {
            this.setErrorCodeIfNotYetSet();
        } else {
            LOG.info("runProcess: exit value unavailable");
        }
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/CapturingProcessHandler", "runProcess"));
        }
        return processOutput;
    }

    private void setErrorCodeIfNotYetSet() {
        if (this.myOutput.hasErrorExitCode()) {
            this.myOutput.setExitCode(this.getProcess().exitValue());
        }
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        return this.runProcess(timeoutInMilliseconds, true);
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (timeoutInMilliseconds <= 0) {
            return this.runProcess();
        }
        this.startNotify();
        if (this.waitFor(timeoutInMilliseconds)) {
            this.setErrorCodeIfNotYetSet();
        } else {
            if (destroyOnTimeout) {
                this.destroyProcess();
            }
            this.myOutput.setTimeout();
        }
        return this.myOutput;
    }

    public Charset getCharset() {
        return this.myCharset != null ? this.myCharset : super.getCharset();
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/process/CapturingProcessHandler", "runProcessWithProgressIndicator"));
        }
        ProcessOutput processOutput = this.runProcessWithProgressIndicator(indicator, Integer.MAX_VALUE);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/CapturingProcessHandler", "runProcessWithProgressIndicator"));
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/process/CapturingProcessHandler", "runProcessWithProgressIndicator"));
        }
        ProcessOutput processOutput = this.runProcessWithProgressIndicator(indicator, timeoutInMilliseconds, true);
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/CapturingProcessHandler", "runProcessWithProgressIndicator"));
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/process/CapturingProcessHandler", "runProcessWithProgressIndicator"));
        }
        int WAIT_INTERVAL = 100;
        int waitingTime = 0;
        boolean setExitCode = true;
        this.startNotify();
        while (!this.waitFor(100L)) {
            boolean destroying;
            boolean timeout = (waitingTime += 100) >= timeoutInMilliseconds;
            boolean canceled = indicator.isCanceled();
            if (!canceled && !timeout) continue;
            setExitCode = destroying = canceled || destroyOnTimeout;
            if (destroying && !this.isProcessTerminating() && !this.isProcessTerminated()) {
                this.destroyProcess();
            }
            if (canceled) {
                this.myOutput.setCancelled();
                break;
            }
            this.myOutput.setTimeout();
            break;
        }
        if (setExitCode) {
            if (this.waitFor()) {
                this.setErrorCodeIfNotYetSet();
            } else {
                LOG.info("runProcess: exit value unavailable");
            }
        }
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/CapturingProcessHandler", "runProcessWithProgressIndicator"));
        }
        return processOutput;
    }
}

