/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JamReferenceContributor
extends PsiReferenceContributor {
    private static final PsiNameValuePairPattern NAME_VALUE_PAIR = (PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withParent(PsiAnnotationParameterList.class);
    public static final PsiJavaElementPattern.Capture<PsiLiteral> STRING_IN_ANNO = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiLiteral().withParent(PsiJavaPatterns.or(new ElementPattern[]{NAME_VALUE_PAIR, PsiJavaPatterns.psiElement(PsiArrayInitializerMemberValue.class).withParent(NAME_VALUE_PAIR)}));

    @Override
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/jam/JamReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(STRING_IN_ANNO, new PsiReferenceProvider(){

            @Override
            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                JamAttributeMeta<?> attribute;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jam/JamReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jam/JamReferenceContributor$1", "getReferencesByElement"));
                }
                PsiNameValuePair pair = PsiTreeUtil.getParentOfType(element, PsiNameValuePair.class);
                PsiAnnotation anno = (PsiAnnotation)pair.getParent().getParent();
                PsiAnnotation originalAnno = (PsiAnnotation)CompletionUtil.getOriginalOrSelf((PsiElement)anno);
                JamService service = JamService.getJamService(pair.getProject());
                JamAnnotationMeta annotationMeta = service.getMeta(originalAnno);
                if (annotationMeta != null && (attribute = annotationMeta.findAttribute(pair.getName())) instanceof JamStringAttributeMeta) {
                    JamStringAttributeMeta meta = (JamStringAttributeMeta)attribute;
                    Object jam = attribute.getJam(PsiElementRef.real(anno));
                    JamConverter converter = meta.getConverter();
                    if (jam instanceof List) {
                        ArrayList refs = ContainerUtil.newArrayList();
                        List list = (List)jam;
                        for (JamStringAttributeElement attributeElement : list) {
                            if (!element.equals(attributeElement.getPsiElement())) continue;
                            ContainerUtil.addAll((Collection)refs, (Object[])converter.createReferences(attributeElement));
                        }
                        PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamReferenceContributor$1", "getReferencesByElement"));
                        }
                        return psiReferenceArray;
                    }
                    PsiReference[] psiReferenceArray = converter.createReferences((JamStringAttributeElement)jam);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamReferenceContributor$1", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }
}

