/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PassThroughIdeFocusManager
extends IdeFocusManager {
    private static final PassThroughIdeFocusManager ourInstance = new PassThroughIdeFocusManager();

    public static PassThroughIdeFocusManager getInstance() {
        return ourInstance;
    }

    @Override
    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "requestFocus"));
        }
        c.requestFocus();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "requestFocus"));
        }
        return actionCallback;
    }

    @Override
    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "requestFocus"));
        }
        ActionCallback actionCallback = command.run();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "requestFocus"));
        }
        return actionCallback;
    }

    @Override
    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "getFocusTargetFor"));
        }
        return comp;
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "doWhenFocusSettlesDown"));
        }
        runnable.run();
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "doWhenFocusSettlesDown"));
        }
        if (!runnable.isExpired()) {
            runnable.run();
        }
    }

    @Override
    public Component getFocusedDescendantFor(Component comp) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        return null;
    }

    @Override
    public boolean dispatch(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "dispatch"));
        }
        return false;
    }

    @Override
    public void typeAheadUntil(ActionCallback done2) {
    }

    @Override
    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "requestDefaultFocus"));
        }
        return actionCallback;
    }

    @Override
    public boolean isFocusTransferEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        Expirable expirable = new Expirable(){

            @Override
            public boolean isExpired() {
                return false;
            }
        };
        if (expirable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "getTimestamp"));
        }
        return expirable;
    }

    @Override
    @NotNull
    public FocusRequestor getFurtherRequestor() {
        PassThroughIdeFocusManager passThroughIdeFocusManager = this;
        if (passThroughIdeFocusManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "getFurtherRequestor"));
        }
        return passThroughIdeFocusManager;
    }

    @Override
    public void revalidateFocus(@NotNull ExpirableRunnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "revalidateFocus"));
        }
    }

    @Override
    public void setTypeaheadEnabled(boolean enabled) {
    }

    @Override
    public Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "runOnOwnContext"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/PassThroughIdeFocusManager", "runOnOwnContext"));
        }
        runnable.run();
    }

    @Override
    public Component getLastFocusedFor(IdeFrame frame) {
        return null;
    }

    @Override
    public IdeFrame getLastFocusedFrame() {
        return null;
    }

    @Override
    public void toFront(JComponent c) {
    }

    @Override
    public boolean isFocusBeingTransferred() {
        return false;
    }

    public void dispose() {
    }
}

