/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public interface RegionPainter<T> {
    public void paint(Graphics2D var1, int var2, int var3, int var4, int var5, T var6);

    public static class Image
    implements RegionPainter<Object> {
        private BufferedImage myImage;

        protected void updateImage(BufferedImage image) {
        }

        protected BufferedImage createImage(int width, int height) {
            return UIUtil.createImage((int)width, (int)height, (int)2);
        }

        protected void invalidate() {
            this.myImage = null;
        }

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Object object) {
            if (width > 0 && height > 0) {
                if (this.myImage == null || width != this.myImage.getWidth() || height != this.myImage.getHeight()) {
                    this.myImage = this.createImage(width, height);
                } else if (this.myImage != null) {
                    this.updateImage(this.myImage);
                }
                if (this.myImage != null) {
                    UIUtil.drawImage((Graphics)g, (BufferedImage)this.myImage, null, (int)x, (int)y);
                }
            }
        }
    }

    public static abstract class Alpha
    implements RegionPainter<Float> {
        @Override
        public final void paint(Graphics2D g, int x, int y, int width, int height, Float value) {
            float alpha = this.getAlpha(value);
            if (alpha > 0.0f) {
                Composite composite = g.getComposite();
                g.setComposite(this.getComposite(alpha));
                this.paint(g, x, y, width, height);
                g.setComposite(composite);
            }
        }

        protected float getAlpha(Float value) {
            return value != null ? value.floatValue() : 0.0f;
        }

        protected Composite getComposite(float alpha) {
            return alpha < 1.0f ? AlphaComposite.SrcOver.derive(alpha) : AlphaComposite.SrcOver;
        }

        protected abstract void paint(Graphics2D var1, int var2, int var3, int var4, int var5);
    }
}

