/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorsProviderBase
extends XDebuggerEditorsProvider {
    @Override
    @NotNull
    public final Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        PsiFile codeFragment = this.createExpressionCodeFragment(project, text, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        return document2;
    }

    @Override
    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        Document document = this.createDocument(project, expression, context, mode);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, @NotNull EvaluationMode mode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        PsiFile codeFragment = this.createExpressionCodeFragment(project, expression, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createDocument"));
        }
        return document2;
    }

    protected abstract PsiFile createExpressionCodeFragment(@NotNull Project var1, @NotNull String var2, @Nullable PsiElement var3, boolean var4);

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createExpressionCodeFragment"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "createExpressionCodeFragment"));
        }
        return this.createExpressionCodeFragment(project, expression.getExpression(), context, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        if (context != null) {
            Collection<Language> collection = this.getSupportedLanguages(context.getProject(), null);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "getSupportedLanguages"));
            }
            return collection;
        }
        List<Language> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "getSupportedLanguages"));
        }
        return list;
    }

    @Nullable
    protected PsiElement getContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "getContextElement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase", "getContextElement"));
        }
        return XDebuggerUtil.getInstance().findContextElement(virtualFile, offset, project, false);
    }
}

