/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.java.CucumberJavaBundle;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaApplicationConfigurable;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter;

public class CucumberJavaRunConfiguration
extends ApplicationConfiguration {
    private NullableComputable<String> glueInitializer = null;
    public String myFilePath;
    public String GLUE;
    public String myNameFilter;
    public String myGeneratedName;

    protected CucumberJavaRunConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, project, factory);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new CucumberJavaApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration", "getState"));
        }
        return new ApplicationConfiguration.JavaApplicationCommandLineState<CucumberJavaRunConfiguration>(this, env){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                File f;
                JavaParameters params = new JavaParameters();
                JavaRunConfigurationModule module = (JavaRunConfigurationModule)CucumberJavaRunConfiguration.this.getConfigurationModule();
                int classPathType = 7;
                String jreHome = CucumberJavaRunConfiguration.this.ALTERNATIVE_JRE_PATH_ENABLED ? CucumberJavaRunConfiguration.this.ALTERNATIVE_JRE_PATH : null;
                JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params, (int)7, (String)jreHome);
                JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)CucumberJavaRunConfiguration.this);
                String path = CucumberJavaRunConfiguration.getSMRunnerPath();
                params.getClassPath().add(path);
                params.setMainClass(CucumberJavaRunConfiguration.this.MAIN_CLASS_NAME);
                for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                    ext.updateJavaParameters((RunConfigurationBase)CucumberJavaRunConfiguration.this, params, this.getRunnerSettings());
                }
                String glueValue = CucumberJavaRunConfiguration.this.getGlue();
                if (glueValue != null && !StringUtil.isEmpty((String)glueValue)) {
                    String[] glues;
                    for (String glue : glues = glueValue.split(" ")) {
                        if (StringUtil.isEmpty((String)glue)) continue;
                        params.getProgramParametersList().addParametersString(" --glue " + glue);
                    }
                }
                if (!(f = new File(CucumberJavaRunConfiguration.this.myFilePath)).isDirectory()) {
                    f = f.getParentFile();
                }
                params.getVMParametersList().addParametersString("-Dorg.jetbrains.run.directory=\"" + f.getAbsolutePath() + "\"");
                params.getProgramParametersList().addParametersString("\"" + CucumberJavaRunConfiguration.this.myFilePath + "\"");
                return params;
            }

            @Nullable
            private ConsoleView createConsole(@NotNull Executor executor, ProcessHandler processHandler) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$1", "createConsole"));
                }
                String testFrameworkName = "cucumber";
                CucumberJavaRunConfiguration runConfiguration = CucumberJavaRunConfiguration.this;
                SMTRunnerConsoleProperties consoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)runConfiguration, "cucumber", executor);
                return SMTestRunnerConnectionUtil.createAndAttachConsole((String)"cucumber", (ProcessHandler)processHandler, (TestConsoleProperties)consoleProperties);
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$1", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$1", "execute"));
                }
                OSProcessHandler processHandler = this.startProcess();
                ConsoleView console = this.createConsole(executor, (ProcessHandler)processHandler);
                DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler, this.createActions(console, (ProcessHandler)processHandler, executor));
                if (defaultExecutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$1", "execute"));
                }
                return defaultExecutionResult;
            }
        };
    }

    private static String getSMRunnerPath() {
        return PathUtil.getJarPathForClass(CucumberJvmSMFormatter.class);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myFilePath == null) {
            throw new RuntimeConfigurationException(CucumberBundle.message((String)"cucumber.run.error.specify.file", (Object[])new Object[0]));
        }
        if (!new File(this.myFilePath).exists()) {
            throw new RuntimeConfigurationException(CucumberBundle.message((String)"cucumber.run.error.file.doesnt.exist", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)this.getGlue())) {
            throw new RuntimeConfigurationException(CucumberJavaBundle.message("cucumber.java.run.configuration.glue.mustnt.be.empty", new Object[0]));
        }
        String programParameters = this.getProgramParameters();
        if (programParameters != null && programParameters.contains("--glue")) {
            throw new RuntimeConfigurationException(CucumberJavaBundle.message("cucumber.java.run.configuration.glue.in.program.parameters", new Object[0]));
        }
        super.checkConfiguration();
    }

    @Nullable
    public String getGlue() {
        if (this.glueInitializer != null) {
            this.GLUE = (String)this.glueInitializer.compute();
            this.glueInitializer = null;
        }
        return this.GLUE;
    }

    public void setGlue(String value) {
        this.GLUE = value;
        this.glueInitializer = null;
    }

    public void setGlue(NullableComputable<String> value) {
        this.glueInitializer = value;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(String filePath) {
        this.myFilePath = filePath;
    }

    public String getNameFilter() {
        return this.myNameFilter;
    }

    public void setNameFilter(String nameFilter) {
        this.myNameFilter = nameFilter;
    }

    @Nullable
    public String suggestedName() {
        return this.myGeneratedName;
    }

    public String getActionName() {
        return this.getName();
    }
}

