/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl;

import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.ui.SelectedBundle;

public abstract class AbstractFrameworkInstanceManager
implements FrameworkInstanceManager {
    @Nullable
    public String getVersion(@NotNull FrameworkInstanceDefinition instance) {
        String path;
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "getVersion"));
        }
        Collection<SelectedBundle> bundles = this.getFrameworkBundles(instance, FrameworkInstanceManager.FrameworkBundleType.SYSTEM);
        if (bundles.size() == 1 && (path = bundles.iterator().next().getBundlePath()) != null) {
            return CachingBundleInfoProvider.getBundleVersion((String)path);
        }
        return null;
    }

    @Override
    @Nullable
    public String checkValidity(@NotNull FrameworkInstanceDefinition instance) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "checkValidity"));
        }
        String basePath = instance.getBaseFolder();
        if (basePath == null || !new File(basePath).isDirectory()) {
            return OsmorcBundle.message("framework.directory.missing", basePath != null ? basePath : "", instance.getFrameworkIntegratorName());
        }
        String version = this.getVersion(instance);
        if (version == null) {
            return OsmorcBundle.message("framework.jar.missing", basePath, instance.getFrameworkIntegratorName());
        }
        if (StringUtil.isEmptyOrSpaces((String)instance.getName())) {
            return OsmorcBundle.message("framework.name.missing", new Object[0]);
        }
        return null;
    }

    @NotNull
    protected Collection<SelectedBundle> collectBundles(@NotNull FrameworkInstanceDefinition instance, @NotNull FrameworkInstanceManager.FrameworkBundleType type, @NotNull String[] bundleDirs, @NotNull Pattern sysNamePattern, @Nullable String sysControlClass, int sysExpected, @Nullable Pattern shellNamePattern, @Nullable String shellControlClass, int shellExpected) {
        int expected;
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
        }
        if (bundleDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleDirs", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
        }
        if (sysNamePattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sysNamePattern", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
        }
        String basePath = instance.getBaseFolder();
        if (basePath == null || !new File(basePath).isDirectory()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
            }
            return list;
        }
        int n = type == FrameworkInstanceManager.FrameworkBundleType.SYSTEM ? sysExpected : (expected = type == FrameworkInstanceManager.FrameworkBundleType.SHELL ? shellExpected : -1);
        if (expected == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
            }
            return list;
        }
        ArrayList bundles = ContainerUtil.newArrayList();
        block0: for (File dir : this.flattenDirPatterns(basePath, bundleDirs)) {
            File[] files;
            for (File file : files = (File[])ObjectUtils.notNull((Object)dir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                FrameworkInstanceManager.FrameworkBundleType bundleType = this.detectType(file, sysNamePattern, sysControlClass, shellNamePattern, shellControlClass);
                if (bundleType != type) continue;
                SelectedBundle bundle = this.makeBundle(file);
                bundles.add(bundle);
                if (expected > 0 && bundles.size() == expected) break block0;
            }
        }
        if (expected > 0 && bundles.size() < expected) {
            List<SelectedBundle> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
            }
            return list;
        }
        ArrayList arrayList = bundles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/AbstractFrameworkInstanceManager", "collectBundles"));
        }
        return arrayList;
    }

    protected List<File> flattenDirPatterns(String basePath, String[] bundleDirs) {
        ArrayList dirs = ContainerUtil.newArrayList();
        for (String subDir : bundleDirs) {
            if (subDir.isEmpty()) {
                dirs.add(new File(basePath));
                continue;
            }
            if (subDir.endsWith("/*")) {
                Object[] nestedDirs = new File(basePath, subDir.substring(0, subDir.length() - 2)).listFiles();
                if (nestedDirs == null) continue;
                ContainerUtil.addAll((Collection)dirs, (Object[])nestedDirs);
                continue;
            }
            dirs.add(new File(basePath, subDir));
        }
        return dirs;
    }

    protected FrameworkInstanceManager.FrameworkBundleType detectType(File file, Pattern sysPattern, String sysClass, Pattern shellPattern, String shellClass) {
        FrameworkInstanceManager.FrameworkBundleType bundleType = null;
        String name = file.getName();
        if (name.endsWith(".jar") && JarUtil.containsEntry((File)file, (String)"META-INF/MANIFEST.MF")) {
            if (sysPattern.matcher(name).matches() && (sysClass == null || JarUtil.containsClass((File)file, (String)sysClass))) {
                bundleType = FrameworkInstanceManager.FrameworkBundleType.SYSTEM;
            } else if (shellPattern != null && shellPattern.matcher(name).matches() && (shellClass == null || JarUtil.containsClass((File)file, (String)shellClass))) {
                bundleType = FrameworkInstanceManager.FrameworkBundleType.SHELL;
            } else if (CachingBundleInfoProvider.isBundle((String)file.getPath())) {
                bundleType = FrameworkInstanceManager.FrameworkBundleType.OTHER;
            }
        }
        return bundleType;
    }

    protected SelectedBundle makeBundle(File file) {
        String path = file.getPath();
        String bundleName = CachingBundleInfoProvider.getBundleSymbolicName((String)path);
        if (bundleName != null) {
            String bundleVersion = CachingBundleInfoProvider.getBundleVersion((String)path);
            if (bundleVersion != null) {
                bundleName = bundleName + " - " + bundleVersion;
            }
        } else {
            bundleName = file.getName();
        }
        return new SelectedBundle(SelectedBundle.BundleType.FrameworkBundle, bundleName, path);
    }
}

