/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.types.PsiGenerator;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JSStubElementType<StubT extends JSStubElement<PsiT>, PsiT extends JSElement>
extends IStubElementType<StubT, PsiT>
implements PsiGenerator {
    public JSStubElementType(@NonNls String debugName) {
        super(debugName, JavaScriptFileType.INSTANCE.getLanguage());
    }

    public String toString() {
        return "JS:" + super.toString();
    }

    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/JSStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/JSStubElementType", "indexStub"));
        }
        stub.index(sink);
    }

    @NotNull
    public String getExternalId() {
        String string = this.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSStubElementType", "getExternalId"));
        }
        return string;
    }

    public PsiT createPsi(@NotNull StubT stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/JSStubElementType", "createPsi"));
        }
        return (PsiT)stub.createPsi();
    }

    public void serialize(@NotNull StubT stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/javascript/psi/JSStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/JSStubElementType", "serialize"));
        }
        stub.serialize(dataStream);
    }

    public boolean shouldIndexSymbol(@NotNull PsiT psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/psi/JSStubElementType", "shouldIndexSymbol"));
        }
        return true;
    }
}

