/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.layout;

import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.layout.MapUndoableWrapper;
import com.intellij.jboss.jbpm.render.size.ChartNodeSizeEnhancer;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.hash.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChartVirtualLayoutCoordinator
implements ChartLayoutCoordinator {
    private final boolean persistAutoGeneratedLayout;
    @NotNull
    private final ChartLayoutCoordinator chartLayoutCoordinator;
    @NotNull
    final Map<String, ChartLayoutCoordinator.NodeLayout> nodeLayouts;
    @NotNull
    final Map<Pair<String, String>, List<ChartLayoutCoordinator.Point>> edgeLayouts;

    public ChartVirtualLayoutCoordinator(@NotNull Project project, DocumentReference[] references, boolean persistAutoGeneratedLayout, @NotNull ChartLayoutCoordinator coordinator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "<init>"));
        }
        if (coordinator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinator", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "<init>"));
        }
        this.nodeLayouts = new MapUndoableWrapper<String, ChartLayoutCoordinator.NodeLayout>(UndoManager.getInstance((Project)project), references, (Map<String, ChartLayoutCoordinator.NodeLayout>)new HashMap());
        this.edgeLayouts = new MapUndoableWrapper<Pair<String, String>, List<ChartLayoutCoordinator.Point>>(UndoManager.getInstance((Project)project), references, (Map<Pair<String, String>, List<ChartLayoutCoordinator.Point>>)new HashMap());
        this.persistAutoGeneratedLayout = persistAutoGeneratedLayout;
        this.chartLayoutCoordinator = coordinator;
    }

    @Override
    @Nullable
    public ChartLayoutCoordinator.NodeLayout getNodeLayout(@NotNull String nodeId, ChartNodeSizeEnhancer enhancer) {
        if (nodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeId", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getNodeLayout"));
        }
        ChartLayoutCoordinator.NodeLayout virtualLayout = this.nodeLayouts.get(nodeId);
        return virtualLayout != null ? virtualLayout : this.chartLayoutCoordinator.getNodeLayout(nodeId, enhancer);
    }

    @Nullable
    public Runnable getCreateNodeLayoutAction(final @NotNull String nodeId, final @NotNull ChartLayoutCoordinator.NodeLayout layout, @Nullable ChartNodeSizeEnhancer enhancer, boolean isAutoGenerated) {
        if (nodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeId", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getCreateNodeLayoutAction"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getCreateNodeLayoutAction"));
        }
        if (isAutoGenerated && !this.persistAutoGeneratedLayout) {
            return new Runnable(){

                @Override
                public void run() {
                    ChartVirtualLayoutCoordinator.this.nodeLayouts.put(nodeId, layout);
                }
            };
        }
        return this.chartLayoutCoordinator.getChangeNodeLayoutAction(nodeId, layout, enhancer);
    }

    @Override
    @Nullable
    public Runnable getChangeNodeLayoutAction(final @NotNull String nodeId, @NotNull ChartLayoutCoordinator.NodeLayout layout, @Nullable ChartNodeSizeEnhancer enhancer) {
        if (nodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeId", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getChangeNodeLayoutAction"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getChangeNodeLayoutAction"));
        }
        ChartLayoutCoordinator.NodeLayout virtualLayout = this.nodeLayouts.get(nodeId);
        if (virtualLayout == null) {
            return this.chartLayoutCoordinator.getChangeNodeLayoutAction(nodeId, layout, enhancer);
        }
        if (!virtualLayout.equals(layout)) {
            final Runnable action = this.chartLayoutCoordinator.getChangeNodeLayoutAction(nodeId, layout, enhancer);
            return new Runnable(){

                @Override
                public void run() {
                    ChartVirtualLayoutCoordinator.this.nodeLayouts.remove(nodeId);
                    if (action != null) {
                        action.run();
                    }
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public List<ChartLayoutCoordinator.Point> getEdgePoints(@NotNull String sourceNodeId, @NotNull String targetNodeId) {
        if (sourceNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodeId", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getEdgePoints"));
        }
        if (targetNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNodeId", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getEdgePoints"));
        }
        List<ChartLayoutCoordinator.Point> points = this.chartLayoutCoordinator.getEdgePoints(sourceNodeId, targetNodeId);
        return points == null ? this.edgeLayouts.get(Pair.create((Object)sourceNodeId, (Object)targetNodeId)) : points;
    }

    @Override
    @Nullable
    public Runnable getChangeEdgePointsAction(@NotNull String sourceNodeId, @NotNull String targetNodeId, @NotNull List<ChartLayoutCoordinator.Point> points) {
        if (sourceNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNodeId", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getChangeEdgePointsAction"));
        }
        if (targetNodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNodeId", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getChangeEdgePointsAction"));
        }
        if (points == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "points", "com/intellij/jboss/jbpm/layout/ChartVirtualLayoutCoordinator", "getChangeEdgePointsAction"));
        }
        return this.chartLayoutCoordinator.getChangeEdgePointsAction(sourceNodeId, targetNodeId, points);
    }
}

