/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.render.background;

import com.intellij.jboss.jbpm.render.ChartNodeRenderer;
import com.intellij.jboss.jbpm.render.RenderArgs;
import com.intellij.jboss.jbpm.render.background.RenderBorder;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ChartNodeBorderRenderer<T>
implements ChartNodeRenderer<T, RenderBorder> {
    @Override
    public void renderComponent(RenderBorder renderBorder, RenderArgs<T> renderArgs) {
        Object border = renderBorder.width() == 0 ? JBUI.Borders.empty() : ChartNodeBorderRenderer.createBorder(renderBorder);
        renderArgs.wrapper.setBorder((Border)border);
        Container outerPanel = renderArgs.wrapper.getParent();
        if (outerPanel instanceof JPanel) {
            ((JPanel)outerPanel).setBorder((Border)border);
        }
    }

    private static Border createBorder(RenderBorder border) {
        int[] rgba_norm = border.rgba();
        int[] rgba_dark = border.rgbaDark();
        return JBUI.Borders.customLine((Color)new JBColor(new Color(rgba_norm[0], rgba_norm[1], rgba_norm[2], rgba_norm[3]), new Color(rgba_dark[0], rgba_dark[1], rgba_dark[2], rgba_dark[3])), (int)border.width());
    }

    @Override
    public Class<RenderBorder> getLayoutClass() {
        return RenderBorder.class;
    }
}

