/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import com.intellij.mock.MockProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Annotation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinNoteFieldDefinition;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.CheckinPoliciesManager;
import org.jetbrains.tfsIntegration.checkin.DuplicatePolicyIdException;
import org.jetbrains.tfsIntegration.checkin.NotInstalledPolicyFailure;
import org.jetbrains.tfsIntegration.checkin.PolicyBase;
import org.jetbrains.tfsIntegration.checkin.PolicyContext;
import org.jetbrains.tfsIntegration.checkin.PolicyDescriptor;
import org.jetbrains.tfsIntegration.checkin.PolicyFailure;
import org.jetbrains.tfsIntegration.checkin.PolicyParseException;
import org.jetbrains.tfsIntegration.checkin.StatefulPolicyDescriptor;
import org.jetbrains.tfsIntegration.checkin.StatefulPolicyParser;
import org.jetbrains.tfsIntegration.checkin.StatelessPolicyParser;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.configuration.TfsCheckinPoliciesCompatibility;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsExecutionUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkItemsCheckinParameters;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class CheckinParameters {
    private final CheckinProjectPanel myPanel;
    private Map<ServerInfo, ServerData> myData;
    private boolean myPoliciesEvaluated;
    private String myOverrideReason;
    private String myPoliciesLoadError;

    private CheckinParameters(CheckinProjectPanel panel, @NotNull Map<ServerInfo, ServerData> data, boolean policiesEvaluated, String policiesLoadError) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/tfsIntegration/checkin/CheckinParameters", "<init>"));
        }
        this.myPanel = panel;
        this.myData = data;
        this.myPoliciesEvaluated = policiesEvaluated;
        this.myPoliciesLoadError = policiesLoadError;
    }

    public CheckinParameters(final CheckinProjectPanel panel, final boolean evaluatePolicies) throws OperationFailedException {
        this.myPanel = panel;
        final ArrayList<FilePath> filePaths = new ArrayList<FilePath>(panel.getFiles().size());
        for (File file : panel.getFiles()) {
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
            if (!TFSVcs.isUnderTFS(filePath, this.myPanel.getProject())) continue;
            filePaths.add(filePath);
        }
        TfsExecutionUtil.ResultWithError<Void> result = TfsExecutionUtil.executeInBackground("Validating Checkin", panel.getProject(), new TfsExecutionUtil.VoidProcess(){

            @Override
            public void run() throws TfsException, VcsException {
                ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                if (pi == null) {
                    pi = new MockProgressIndicator();
                }
                pi.setText("Loading checkin notes and policy definitions");
                final MultiMap serverToProjects = MultiMap.createSet();
                final HashMap serverToFiles = new HashMap();
                WorkstationHelper.processByWorkspaces(filePaths, false, panel.getProject(), new WorkstationHelper.VoidProcessDelegate(){

                    @Override
                    public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                        ArrayList<FilePath> files = (ArrayList<FilePath>)serverToFiles.get(workspace.getServer());
                        if (files == null) {
                            files = new ArrayList<FilePath>();
                            serverToFiles.put(workspace.getServer(), files);
                        }
                        for (ItemPath path : paths) {
                            serverToProjects.putValue((Object)workspace.getServer(), (Object)VersionControlPath.getPathToProject(path.getServerPath()));
                            files.add(path.getLocalPath());
                        }
                    }
                });
                if (serverToProjects.isEmpty()) {
                    throw new OperationFailedException("Team Foundation Server mappings not found.");
                }
                pi.checkCanceled();
                ArrayList sortedServers = new ArrayList(serverToProjects.keySet());
                Collections.sort(sortedServers, new Comparator<ServerInfo>(){

                    @Override
                    public int compare(ServerInfo o1, ServerInfo o2) {
                        return o1.getPresentableUri().compareTo(o2.getPresentableUri());
                    }
                });
                LinkedHashMap<ServerInfo, ServerData> data = new LinkedHashMap<ServerInfo, ServerData>();
                StringBuilder policiesLoadError = new StringBuilder();
                for (ServerInfo server : sortedServers) {
                    Object checkinNote22;
                    Collection teamProjects = serverToProjects.get((Object)server);
                    List<CheckinNoteFieldDefinition> checkinNoteDefinitions = server.getVCS().queryCheckinNoteDefinition(teamProjects, CheckinParameters.this.myPanel.getProject(), null);
                    pi.checkCanceled();
                    HashMap<String, CheckinNoteFieldDefinition> nameToDefinition = new HashMap<String, CheckinNoteFieldDefinition>();
                    for (CheckinNoteFieldDefinition definition : checkinNoteDefinitions) {
                        if (nameToDefinition.containsKey(definition.getName()) && !definition.getReq()) continue;
                        nameToDefinition.put(definition.getName(), definition);
                    }
                    ArrayList sortedDefinitions = new ArrayList(nameToDefinition.values());
                    Collections.sort(sortedDefinitions, new Comparator<CheckinNoteFieldDefinition>(){

                        @Override
                        public int compare(CheckinNoteFieldDefinition o1, CheckinNoteFieldDefinition o2) {
                            return o1.get_do() - o2.get_do();
                        }
                    });
                    ArrayList<CheckinNote> checkinNotes = new ArrayList<CheckinNote>(sortedDefinitions.size());
                    for (Object checkinNote22 : sortedDefinitions) {
                        checkinNotes.add(new CheckinNote(checkinNote22.getName(), checkinNote22.getReq()));
                    }
                    HashMap<String, TeamProjectData> project2policies = new HashMap<String, TeamProjectData>();
                    checkinNote22 = teamProjects.iterator();
                    while (checkinNote22.hasNext()) {
                        String teamProject = (String)checkinNote22.next();
                        project2policies.put(teamProject, new TeamProjectData());
                    }
                    try {
                        TeamProjectData teamProjectData;
                        String teamProject;
                        ArrayList<Annotation> annotations;
                        ArrayList<Annotation> overridesAnnotations = new ArrayList<Annotation>();
                        for (String teamProjectPath : teamProjects) {
                            overridesAnnotations.addAll(server.getVCS().queryAnnotations("IntellijOverrides", teamProjectPath, CheckinParameters.this.myPanel.getProject(), null, false));
                        }
                        boolean teamExplorerFound = TFSConfigurationManager.getInstance().getCheckinPoliciesCompatibility().teamExplorer;
                        boolean teampriseFound = TFSConfigurationManager.getInstance().getCheckinPoliciesCompatibility().teamprise;
                        for (Annotation annotation : overridesAnnotations) {
                            TfsCheckinPoliciesCompatibility override;
                            if (annotation.getValue() == null) continue;
                            String teamProject2 = VersionControlPath.getPathToProject(annotation.getItem());
                            ((TeamProjectData)project2policies.get((Object)teamProject2)).myCompatibility = override = TfsCheckinPoliciesCompatibility.fromOverridesAnnotationValue(annotation.getValue());
                            teamExplorerFound |= override.teamExplorer;
                            teampriseFound |= override.teamprise;
                        }
                        if (teamExplorerFound) {
                            annotations = new ArrayList<Annotation>();
                            for (String teamProjectPath : teamProjects) {
                                annotations.addAll(server.getVCS().queryAnnotations("CheckinPolicies", teamProjectPath, CheckinParameters.this.myPanel.getProject(), null, false));
                            }
                            for (Annotation annotation : annotations) {
                                if (annotation.getValue() == null) continue;
                                teamProject = VersionControlPath.getPathToProject(annotation.getItem());
                                teamProjectData = (TeamProjectData)project2policies.get(teamProject);
                                if (!teamProjectData.myCompatibility.teamExplorer) continue;
                                for (PolicyDescriptor policyDescriptor : StatelessPolicyParser.parseDescriptors(annotation.getValue())) {
                                    if (!policyDescriptor.isEnabled()) continue;
                                    teamProjectData.myPolicies.add(policyDescriptor);
                                }
                            }
                        }
                        if (teampriseFound) {
                            annotations = new ArrayList();
                            for (String teamProjectPath : teamProjects) {
                                annotations.addAll(server.getVCS().queryAnnotations("TeampriseCheckinPolicies", teamProjectPath, CheckinParameters.this.myPanel.getProject(), null, false));
                            }
                            for (Annotation annotation : annotations) {
                                if (annotation.getValue() == null) continue;
                                teamProject = VersionControlPath.getPathToProject(annotation.getItem());
                                teamProjectData = (TeamProjectData)project2policies.get(teamProject);
                                if (!teamProjectData.myCompatibility.teamprise) continue;
                                for (PolicyDescriptor policyDescriptor : StatefulPolicyParser.parseDescriptors(annotation.getValue())) {
                                    if (!policyDescriptor.isEnabled()) continue;
                                    teamProjectData.myPolicies.add(policyDescriptor);
                                }
                            }
                        }
                    }
                    catch (PolicyParseException e) {
                        policiesLoadError.append(e.getMessage());
                    }
                    catch (JDOMException e) {
                        policiesLoadError.append(e.getMessage());
                    }
                    catch (IOException e) {
                        policiesLoadError.append(e.getMessage());
                    }
                    pi.checkCanceled();
                    data.put(server, new ServerData(checkinNotes, new WorkItemsCheckinParameters(), (Collection)serverToFiles.get(server), project2policies));
                }
                CheckinParameters.this.myPoliciesLoadError = policiesLoadError.length() > 0 ? policiesLoadError.toString() : null;
                CheckinParameters.this.myData = data;
                if (evaluatePolicies) {
                    pi.setText("Evaluating checkin policies");
                    CheckinParameters.this.evaluatePolicies(pi);
                    CheckinParameters.this.myPoliciesEvaluated = true;
                }
            }
        });
        if (this.myData == null) {
            throw new OperationFailedException(result.cancelled ? "Validation cancelled by user" : result.error.getMessage());
        }
        this.validateNotes();
    }

    public boolean policiesEvaluated() {
        return this.myPoliciesEvaluated;
    }

    public String getPoliciesLoadError() {
        return this.myPoliciesLoadError;
    }

    public void evaluatePolicies(ProgressIndicator pi) {
        for (Map.Entry<ServerInfo, ServerData> entry : this.myData.entrySet()) {
            PolicyContext context = this.createPolicyContext(entry.getKey());
            ArrayList<PolicyFailure> allFailures = new ArrayList<PolicyFailure>();
            block9: for (Map.Entry<String, TeamProjectData> teamProjectDataEntry : entry.getValue().myPolicies.entrySet()) {
                for (PolicyDescriptor descriptor : teamProjectDataEntry.getValue().myPolicies) {
                    String tooltip;
                    String message;
                    PolicyBase policy;
                    try {
                        policy = CheckinPoliciesManager.find(descriptor.getType());
                    }
                    catch (DuplicatePolicyIdException e) {
                        String tooltip2 = MessageFormat.format("Several checkin policies with the same id found: ''{0}''.\nPlease review your extensions.", e.getDuplicateId());
                        allFailures.add(new PolicyFailure(CheckinPoliciesManager.DUMMY_POLICY, "Duplicate checkin policy id", tooltip2));
                        continue block9;
                    }
                    if (policy == null) {
                        if (!teamProjectDataEntry.getValue().myCompatibility.nonInstalled) continue;
                        allFailures.add(new NotInstalledPolicyFailure(descriptor.getType(), !(descriptor instanceof StatefulPolicyDescriptor)));
                        continue;
                    }
                    pi.setText(MessageFormat.format("Evaluating checkin policy: {0}", policy.getPolicyType().getName()));
                    pi.setText2("");
                    if (descriptor instanceof StatefulPolicyDescriptor) {
                        try {
                            policy.loadState(((StatefulPolicyDescriptor)descriptor).getConfiguration().clone());
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            TFSVcs.LOG.warn((Throwable)e);
                            message = MessageFormat.format("Cannot load configuration of checkin policy ''{0}''", policy.getPolicyType().getName());
                            tooltip = MessageFormat.format("The following error occured while loading: {0}", e.getMessage());
                            allFailures.add(new PolicyFailure(CheckinPoliciesManager.DUMMY_POLICY, message, tooltip));
                            continue;
                        }
                    }
                    try {
                        Object[] failures = policy.evaluate(context, pi);
                        ContainerUtil.addAll(allFailures, (Object[])failures);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        TFSVcs.LOG.warn((Throwable)e);
                        message = MessageFormat.format("Cannot evaluate checkin policy ''{0}''", policy.getPolicyType().getName());
                        tooltip = MessageFormat.format("The following error occured while evaluating: {0}", e.getMessage());
                        allFailures.add(new PolicyFailure(CheckinPoliciesManager.DUMMY_POLICY, message, tooltip));
                    }
                    pi.checkCanceled();
                }
            }
            entry.getValue().myPolicyFailures = allFailures;
        }
        this.myPoliciesEvaluated = true;
    }

    public PolicyContext createPolicyContext(ServerInfo server) {
        final ServerData serverData = this.myData.get(server);
        return new PolicyContext(){

            @Override
            public Collection<FilePath> getFiles() {
                return Collections.unmodifiableCollection(serverData.myFiles);
            }

            @Override
            public Project getProject() {
                return CheckinParameters.this.myPanel.getProject();
            }

            @Override
            public String getCommitMessage() {
                return CheckinParameters.this.myPanel.getCommitMessage();
            }

            @Override
            public Map<WorkItem, PolicyContext.WorkItemAction> getWorkItems() {
                HashMap<WorkItem, PolicyContext.WorkItemAction> result = new HashMap<WorkItem, PolicyContext.WorkItemAction>(serverData.myWorkItems.getWorkItemsActions().size());
                for (Map.Entry<WorkItem, CheckinWorkItemAction> entry : serverData.myWorkItems.getWorkItemsActions().entrySet()) {
                    result.put(entry.getKey(), entry.getValue() == CheckinWorkItemAction.Associate ? PolicyContext.WorkItemAction.Associate : PolicyContext.WorkItemAction.Resolve);
                }
                return result;
            }
        };
    }

    public boolean evaluationEnabled() {
        for (ServerData data : this.myData.values()) {
            for (TeamProjectData teamProjectData : data.myPolicies.values()) {
                if (!teamProjectData.myCompatibility.teamExplorer && !teamProjectData.myCompatibility.teamprise) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Pair<String, Severity> getValidationMessage(Severity severity) {
        boolean checkWarning;
        StringBuilder result = new StringBuilder();
        Severity resultingSeverity = Severity.WARNING;
        boolean checkError = severity == Severity.ERROR || severity == Severity.BOTH;
        boolean bl = checkWarning = severity == Severity.WARNING || severity == Severity.BOTH;
        if (!this.myPoliciesEvaluated && checkWarning) {
            if (this.evaluationEnabled()) {
                result.append("Checkin policies were not evaluated");
            }
            checkWarning = false;
        }
        for (Map.Entry<ServerInfo, ServerData> entry : this.myData.entrySet()) {
            ServerData data = entry.getValue();
            if ((!checkError || data.myEmptyNotes.isEmpty()) && (!checkWarning || data.myPolicyFailures.isEmpty())) continue;
            if (result.length() > 0) {
                result.append("\n");
            }
            if (this.myData.size() > 1) {
                result.append(entry.getKey().getPresentableUri()).append("\n");
            }
            if (checkError && !data.myEmptyNotes.isEmpty()) {
                resultingSeverity = Severity.ERROR;
                String message = data.myEmptyNotes.size() > 1 ? MessageFormat.format("Checkin notes ''{0}'' are required to commit", StringUtil.join((String[])ArrayUtil.toStringArray(data.myEmptyNotes), (String)"', '")) : MessageFormat.format("Checkin note ''{0}'' is required to commit", data.myEmptyNotes.iterator().next());
                result.append(message);
            }
            if (!checkWarning || data.myPolicyFailures.isEmpty()) continue;
            if (checkError && !data.myEmptyNotes.isEmpty()) {
                result.append("\n");
            }
            result.append("Checkin policy warnings found");
        }
        return result.length() > 0 ? Pair.create((Object)result.toString(), (Object)((Object)resultingSeverity)) : null;
    }

    public void validateNotes() {
        for (ServerData serverData : this.myData.values()) {
            ArrayList<String> emptyNotes = new ArrayList<String>();
            for (CheckinNote checkinNote : serverData.myCheckinNotes) {
                if (!checkinNote.required || !StringUtil.isEmptyOrSpaces((String)checkinNote.value)) continue;
                emptyNotes.add(checkinNote.name);
            }
            serverData.myEmptyNotes = emptyNotes;
        }
    }

    public List<ServerInfo> getServers() {
        return new ArrayList<ServerInfo>(this.myData.keySet());
    }

    @NotNull
    public Set<String> getProjectPaths(@NotNull ServerInfo server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/checkin/CheckinParameters", "getProjectPaths"));
        }
        Set<String> set = this.myData.get((Object)server).myPolicies.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/checkin/CheckinParameters", "getProjectPaths"));
        }
        return set;
    }

    public List<CheckinNote> getCheckinNotes(ServerInfo server) {
        return Collections.unmodifiableList(this.myData.get((Object)server).myCheckinNotes);
    }

    public boolean hasEmptyNotes(ServerInfo server) {
        return !this.myData.get((Object)server).myEmptyNotes.isEmpty();
    }

    public boolean hasPolicyFailures(ServerInfo server) {
        ServerData serverData = this.myData.get(server);
        boolean evaluationEnabled = false;
        for (TeamProjectData teamProjectData : serverData.myPolicies.values()) {
            if (!teamProjectData.myCompatibility.teamExplorer && !teamProjectData.myCompatibility.teamprise) continue;
            evaluationEnabled = true;
            break;
        }
        return evaluationEnabled && (!this.myPoliciesEvaluated || !serverData.myPolicyFailures.isEmpty());
    }

    public List<PolicyFailure> getFailures(ServerInfo server) {
        if (!this.myPoliciesEvaluated) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.myData.get((Object)server).myPolicyFailures);
    }

    public List<PolicyFailure> getAllFailures() {
        if (!this.myPoliciesEvaluated) {
            return Collections.emptyList();
        }
        ArrayList<PolicyFailure> result = new ArrayList<PolicyFailure>();
        for (ServerData data : this.myData.values()) {
            result.addAll(data.myPolicyFailures);
        }
        return result;
    }

    public WorkItemsCheckinParameters getWorkItems(ServerInfo server) {
        return this.myData.get((Object)server).myWorkItems;
    }

    public CheckinParameters createCopy() {
        LinkedHashMap<ServerInfo, ServerData> result = new LinkedHashMap<ServerInfo, ServerData>(this.myData.size());
        for (Map.Entry<ServerInfo, ServerData> entry : this.myData.entrySet()) {
            ServerData serverData = entry.getValue();
            ArrayList<CheckinNote> checkinNotesCopy = new ArrayList<CheckinNote>(serverData.myCheckinNotes.size());
            for (CheckinNote original : serverData.myCheckinNotes) {
                CheckinNote copy = new CheckinNote(original.name, original.required);
                copy.value = original.value;
                checkinNotesCopy.add(copy);
            }
            ServerData serverDataCopy = new ServerData(checkinNotesCopy, serverData.myWorkItems.createCopy(), serverData.myFiles, serverData.myPolicies);
            serverDataCopy.myEmptyNotes = new ArrayList<String>(serverData.myEmptyNotes);
            serverDataCopy.myPolicyFailures = serverData.myPolicyFailures;
            result.put(entry.getKey(), serverDataCopy);
        }
        return new CheckinParameters(this.myPanel, result, this.myPoliciesEvaluated, this.myPoliciesLoadError);
    }

    public void setOverrideReason(String value) {
        this.myOverrideReason = value;
    }

    @Nullable
    public Pair<String, Map<String, String>> getPolicyOverride(ServerInfo server) {
        if (this.myOverrideReason == null) {
            return null;
        }
        LinkedHashMap<String, String> failures = new LinkedHashMap<String, String>();
        for (PolicyFailure policyFailure : this.myData.get((Object)server).myPolicyFailures) {
            failures.put(policyFailure.getPolicyName(), policyFailure.getMessage());
        }
        return Pair.create((Object)this.myOverrideReason, failures);
    }

    public static enum Severity {
        ERROR,
        WARNING,
        BOTH;

    }

    private static class ServerData {
        public final List<CheckinNote> myCheckinNotes;
        public final WorkItemsCheckinParameters myWorkItems;
        public List<PolicyFailure> myPolicyFailures;
        public List<String> myEmptyNotes;
        public final Collection<FilePath> myFiles;
        public final Map<String, TeamProjectData> myPolicies;

        private ServerData(List<CheckinNote> checkinNotes, WorkItemsCheckinParameters workItems, Collection<FilePath> files, Map<String, TeamProjectData> policies) {
            this.myCheckinNotes = checkinNotes;
            this.myWorkItems = workItems;
            this.myPolicies = policies;
            this.myFiles = files;
        }
    }

    private static class TeamProjectData {
        public TfsCheckinPoliciesCompatibility myCompatibility = TFSConfigurationManager.getInstance().getCheckinPoliciesCompatibility();
        public final List<PolicyDescriptor> myPolicies = new ArrayList<PolicyDescriptor>();

        private TeamProjectData() {
        }
    }

    public static class CheckinNote {
        @NotNull
        public final String name;
        public final boolean required;
        @Nullable
        public String value;

        private CheckinNote(String name, boolean required) {
            this.name = name;
            this.required = required;
        }
    }
}

