/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.axis;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ws.WebServicesPlugin;
import com.intellij.ws.actions.ShowDeployedWebSevicesDialog;
import com.intellij.ws.engines.axis.AxisUtil;
import com.intellij.ws.utils.BaseWSAction;
import com.intellij.ws.utils.LibUtils;
import java.util.ArrayList;
import java.util.List;

public class MonitorSoapMessagesAction
extends BaseWSAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)dataContext.getData(DataConstants.PROJECT);
        ShowDeployedWebSevicesDialog dialog = new ShowDeployedWebSevicesDialog(project, "Monitor SOAP Messages", "MonitorSoapMessages.html", MonitorSoapMessagesAction.getPossiblePorts(project));
        if (dialog.showAndGet()) {
            String contextName = dialog.getContextName();
            WebServicesPlugin instance = WebServicesPlugin.getInstance(project);
            instance.addLastContext(contextName);
            int port = dialog.getPort();
            if (!instance.hasSoapMessagesToolWindow(port)) {
                AxisUtil.ensureSoapMonitorDeployed(contextName, project);
            }
            instance.createOrShowSoapMessagesToolWindow(port);
        }
    }

    private static List<String> getPossiblePorts(final Project myProject) {
        final ArrayList<String> ports = new ArrayList<String>(1);
        ProjectRootManager.getInstance((Project)myProject).getFileIndex().iterateContent(new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                XmlFile file;
                XmlTag rootTag;
                XmlTag[] tags;
                XmlTag servlet;
                if (fileOrDir.getName().equals("web.xml") && (servlet = LibUtils.findServletWithName(tags = (rootTag = (file = (XmlFile)PsiManager.getInstance((Project)myProject).findFile(fileOrDir)).getDocument().getRootTag()).findSubTags("servlet"), "SOAPMonitorService", null)) != null) {
                    XmlTag[] subTags;
                    for (XmlTag st : subTags = servlet.findSubTags("init-param")) {
                        String stringValue;
                        XmlTag value;
                        XmlTag firstSubTag = st.findFirstSubTag("param-name");
                        if (firstSubTag == null || !"SOAPMonitorPort".equals(LibUtils.getStringValue(firstSubTag)) || (value = st.findFirstSubTag("param-value")) == null || (stringValue = LibUtils.getStringValue(value)) == null) continue;
                        try {
                            int i = Integer.parseInt(stringValue);
                            ports.add(stringValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                return true;
            }
        });
        return ports;
    }
}

