/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.ParameterReceiverElement;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryAttributeDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryHtmlTagDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryIdOrTypeAttributeDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryNamespaceDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryParameterDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryTagDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryUnknownTagDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.psi.TmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DescriptorUtil {
    private DescriptorUtil() {
    }

    public static XmlAttributeDescriptor[] getAttributeDescriptors(@NotNull XmlTag context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getAttributeDescriptors"));
        }
        XmlAttributeDescriptor[] result = DescriptorUtil.getAttributeDescriptorsImpl(context);
        List<Mixin> mixins = DescriptorUtil.findMixins(context);
        if (mixins.isEmpty()) {
            return result;
        }
        ArrayList listResult = new ArrayList(result.length);
        Collections.addAll(listResult, result);
        for (Mixin mixin : mixins) {
            ContainerUtil.addAll(listResult, (Object[])DescriptorUtil.getAttributeDescriptors(mixin, null));
        }
        return listResult.toArray(new XmlAttributeDescriptor[listResult.size()]);
    }

    private static XmlAttributeDescriptor[] getAttributeDescriptorsImpl(XmlTag context) {
        Component component = TapestryUtils.getTypeOfTag(context);
        String id = DescriptorUtil.getTAttributeName(context, "id");
        if (component != null) {
            return DescriptorUtil.getAttributeDescriptors(component, id == null ? null : new TapestryIdOrTypeAttributeDescriptor(id, context));
        }
        if (id == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        String type = DescriptorUtil.getTAttributeName(context, "type");
        return new XmlAttributeDescriptor[]{new TapestryIdOrTypeAttributeDescriptor(type, context), new TapestryIdOrTypeAttributeDescriptor(id, context)};
    }

    @Nullable
    static String getTAttributeName(@NotNull XmlTag context, String attrName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getTAttributeName"));
        }
        String prefix = context.getPrefixByNamespace(TapestryXmlExtension.getTapestryNamespace(context));
        if (prefix == null) {
            return null;
        }
        return prefix.length() > 0 ? prefix + ":" + attrName : attrName;
    }

    @Nullable
    private static XmlElementDescriptor getImplicitHtmlContainer(@NotNull ParameterReceiverElement component, @NotNull XmlTag context) {
        XmlNSDescriptor descriptor;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getImplicitHtmlContainer"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getImplicitHtmlContainer"));
        }
        IJavaClassType aClass = component.getElementClass();
        if (aClass != null && aClass.supportsInformalParameters() && (descriptor = context.getNSDescriptor("http://www.w3.org/1999/xhtml", false)) instanceof XmlNSDescriptorEx) {
            return ((XmlNSDescriptorEx)descriptor).getElementDescriptor("div", "http://www.w3.org/1999/xhtml");
        }
        return null;
    }

    public static XmlAttributeDescriptor[] getAttributeDescriptors(@Nullable ParameterReceiverElement component, @Nullable TapestryIdOrTypeAttributeDescriptor idAttrDescriptor) {
        XmlElementDescriptor div;
        PsiElement declaration;
        if (component == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        XmlAttributeDescriptor[] additionalParameters = XmlAttributeDescriptor.EMPTY;
        if (idAttrDescriptor != null && (declaration = idAttrDescriptor.getDeclaration()) instanceof XmlTag && (div = DescriptorUtil.getImplicitHtmlContainer(component, (XmlTag)declaration)) != null) {
            additionalParameters = div.getAttributesDescriptors((XmlTag)declaration);
        }
        Collection<TapestryParameter> params = component.getParameters().values();
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[params.size() + (idAttrDescriptor != null ? 1 : 0) + additionalParameters.length];
        int i = 0;
        for (TapestryParameter param : params) {
            descriptors[i++] = new TapestryAttributeDescriptor(param);
        }
        if (idAttrDescriptor != null) {
            descriptors[i++] = idAttrDescriptor;
        }
        for (XmlAttributeDescriptor attr : additionalParameters) {
            descriptors[i++] = attr;
        }
        return descriptors;
    }

    @Nullable
    public static XmlAttributeDescriptor getAttributeDescriptor(@NotNull String attributeName, @NotNull XmlTag context) {
        XmlElementDescriptor container;
        List<Mixin> mixins;
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getAttributeDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getAttributeDescriptor"));
        }
        String prefix = XmlUtil.findPrefixByQualifiedName((String)attributeName);
        if (prefix.length() != 0 && context.getNamespaceByPrefix(prefix).length() == 0) {
            return null;
        }
        XmlAttribute attr = TapestryUtils.getIdentifyingAttribute(context);
        if (attr != null && attr.getName().equals(attributeName)) {
            return new TapestryIdOrTypeAttributeDescriptor(attributeName, context);
        }
        String id = DescriptorUtil.getTAttributeName(context, "id");
        if (attributeName.equals(id)) {
            return new TapestryIdOrTypeAttributeDescriptor(id, context);
        }
        Component component = TapestryUtils.getTypeOfTag(context);
        XmlAttributeDescriptor descriptor = DescriptorUtil.getAttributeDescriptor(attributeName, component, mixins = DescriptorUtil.findMixins(context));
        if (descriptor != null) {
            return descriptor;
        }
        if (component != null && (container = DescriptorUtil.getImplicitHtmlContainer(component, context)) != null && (descriptor = container.getAttributeDescriptor(attributeName, context)) == null && attributeName.indexOf(58) == -1) {
            descriptor = new AnyXmlAttributeDescriptor(attributeName);
        }
        return descriptor;
    }

    @Nullable
    public static XmlAttributeDescriptor getAttributeDescriptor(@NotNull String attributeName, @Nullable ParameterReceiverElement component, List<Mixin> mixins) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getAttributeDescriptor"));
        }
        XmlAttributeDescriptor descriptor = DescriptorUtil.getAttributeDescriptor(attributeName, component);
        if (descriptor != null) {
            return descriptor;
        }
        for (Mixin mixin : mixins) {
            descriptor = DescriptorUtil.getAttributeDescriptor(attributeName, mixin);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Nullable
    public static XmlAttributeDescriptor getAttributeDescriptor(@NotNull String attributeName, @Nullable ParameterReceiverElement component) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getAttributeDescriptor"));
        }
        if (component == null) {
            return null;
        }
        TapestryParameter param = component.getParameters().get(XmlUtil.findLocalNameByQualifiedName((String)attributeName));
        return param == null ? null : new TapestryAttributeDescriptor(param);
    }

    public static XmlElementDescriptor[] getTmlSubelementDescriptors(@NotNull XmlTag context, TapestryNamespaceDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getTmlSubelementDescriptors"));
        }
        TapestryProject project = TapestryModuleSupportLoader.getTapestryProject((XmlElement)context);
        if (project == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        String namespacePrefix = context.getPrefixByNamespace(TapestryXmlExtension.getTapestryNamespace(context));
        Object[] namespaceElements = DescriptorUtil.getElementDescriptors(project.getAvailableElements(), namespacePrefix, descriptor, context);
        String parametersPrefix = context.getPrefixByNamespace("tapestry:parameter");
        Component component = TapestryUtils.getTypeOfTag(context);
        if (parametersPrefix == null || component == null) {
            return namespaceElements;
        }
        Object[] parameterElements = DescriptorUtil.getParameterDescriptors(component, parametersPrefix, DescriptorUtil.findMixins(context), descriptor);
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])namespaceElements, (Object[])parameterElements);
    }

    private static XmlElementDescriptor[] getElementDescriptors(@NotNull Collection<PresentationLibraryElement> elements, String namespacePrefix, TapestryNamespaceDescriptor descriptor, XmlTag context) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getElementDescriptors"));
        }
        Object[] descriptors = new TapestryTagDescriptor[elements.size()];
        int i = 0;
        for (PresentationLibraryElement component : elements) {
            descriptors[i++] = new TapestryTagDescriptor(component, namespacePrefix, descriptor);
        }
        Object[] descriptorsFromSchema = descriptor.getSuperRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class));
        return (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])descriptorsFromSchema);
    }

    private static XmlElementDescriptor[] getParameterDescriptors(@NotNull Component component, String namespacePrefix, List<Mixin> mixins, TapestryNamespaceDescriptor descriptor) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getParameterDescriptors"));
        }
        Function mapping = parameter -> {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "lambda$getParameterDescriptors$0"));
            }
            return new TapestryParameterDescriptor(component, (TapestryParameter)parameter, namespacePrefix, descriptor);
        };
        ArrayList result = new ArrayList(ContainerUtil.map(component.getParameters().values(), (Function)mapping));
        for (Mixin mixin : mixins) {
            result.addAll(ContainerUtil.map(mixin.getParameters().values(), (Function)mapping));
        }
        return (XmlElementDescriptor[])ArrayUtil.toObjectArray(result, XmlElementDescriptor.class);
    }

    @Nullable
    public static XmlElementDescriptor getTmlOrHtmlTagDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "getTmlOrHtmlTagDescriptor"));
        }
        TmlFile file = DescriptorUtil.getTmlFile(tag);
        if (file == null) {
            return null;
        }
        XmlElementDescriptor tmlDescriptor = DescriptorUtil.getTmlTagDescriptor(tag);
        if (tmlDescriptor != null) {
            return tmlDescriptor;
        }
        XmlElementDescriptor htmlDescriptor = DescriptorUtil.getHtmlTagDescriptor(tag, file);
        List<Mixin> mixins = DescriptorUtil.findMixins(tag);
        return htmlDescriptor != null ? new TapestryHtmlTagDescriptor(htmlDescriptor, TapestryUtils.getTypeOfTag(tag), mixins, TapestryXmlExtension.getTapestryTemplateDescriptor(tag)) : null;
    }

    @Nullable
    public static XmlElementDescriptor getHtmlTagDescriptorViaNsDescriptor(XmlTag tag) {
        TmlFile file = DescriptorUtil.getTmlFile(tag);
        return file == null ? null : DescriptorUtil.getHtmlTagDescriptor(tag, file);
    }

    @Nullable
    private static XmlElementDescriptor getHtmlTagDescriptor(XmlTag tag, TmlFile file) {
        XmlNSDescriptor htmlNSDescriptor = DescriptorUtil.getHtmlNSDescriptor(file);
        return htmlNSDescriptor instanceof XmlNSDescriptorImpl ? ((XmlNSDescriptorImpl)htmlNSDescriptor).getElementDescriptor(tag.getLocalName(), tag.getNamespace()) : htmlNSDescriptor.getElementDescriptor(tag);
    }

    @Nullable
    private static TmlFile getTmlFile(XmlTag tag) {
        PsiFile file = tag.getContainingFile();
        if (file instanceof TmlFile) {
            return (TmlFile)file;
        }
        XmlElement parentTag = (XmlElement)tag.getUserData(XmlElement.INCLUDING_ELEMENT);
        if (parentTag == null) {
            return null;
        }
        file = parentTag.getContainingFile();
        return file instanceof TmlFile ? (TmlFile)file : null;
    }

    @Nullable
    public static XmlNSDescriptor getHtmlNSDescriptor(TmlFile tmlFile) {
        XmlDocument doc = tmlFile.getDocument();
        if (doc == null) {
            return null;
        }
        return doc.getDefaultNSDescriptor("http://www.w3.org/1999/xhtml", false);
    }

    @Nullable
    public static XmlElementDescriptor getTmlTagDescriptor(XmlTag tag) {
        String prefix = tag.getNamespacePrefix();
        String tagNamespace = tag.getNamespace();
        if (TapestryXmlExtension.isTapestryTemplateNamespace(tagNamespace)) {
            XmlElementDescriptor descriptorFromTapestrySchema;
            Component component = TapestryUtils.getTypeOfTag(tag);
            List<Mixin> mixins = DescriptorUtil.findMixins(tag);
            TapestryNamespaceDescriptor tapestryNamespaceDescriptor = TapestryXmlExtension.getTapestryTemplateDescriptor(tag);
            if (mixins.isEmpty() && component == null && (descriptorFromTapestrySchema = tapestryNamespaceDescriptor.getElementDescriptor(tag.getLocalName(), tagNamespace)) != null) {
                return new TapestryHtmlTagDescriptor(descriptorFromTapestrySchema, null, mixins, tapestryNamespaceDescriptor);
            }
            return component == null ? new TapestryUnknownTagDescriptor(tag.getLocalName(), prefix, tapestryNamespaceDescriptor) : new TapestryTagDescriptor(component, mixins, prefix, tapestryNamespaceDescriptor);
        }
        if ("tapestry:parameter".equals(tagNamespace)) {
            XmlTag parentTag = tag.getParentTag();
            Component component = parentTag != null ? TapestryUtils.getTypeOfTag(parentTag) : null;
            String parameterName = tag.getLocalName();
            TapestryParameter parameter = component == null ? null : component.getParameters().get(parameterName);
            TapestryNamespaceDescriptor tapestryNamespaceDescriptor = TapestryXmlExtension.getTapestryTemplateDescriptor(tag);
            return parameter == null ? new TapestryUnknownTagDescriptor(parameterName, prefix, tapestryNamespaceDescriptor) : new TapestryParameterDescriptor(component, parameter, prefix, tapestryNamespaceDescriptor);
        }
        return null;
    }

    @NotNull
    private static List<Mixin> findMixins(@Nullable XmlTag tag) {
        String[] components;
        if (tag == null) {
            List<Mixin> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "findMixins"));
            }
            return list;
        }
        TapestryProject tapestryProject = TapestryUtils.getTapestryProject((PsiElement)tag);
        XmlAttribute mixinsAttribute = tag.getAttribute("mixins", TapestryXmlExtension.getTapestryNamespace(tag));
        if (tapestryProject == null || mixinsAttribute == null) {
            List<Mixin> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "findMixins"));
            }
            return list;
        }
        ArrayList<Mixin> result = new ArrayList<Mixin>();
        String value = mixinsAttribute.getValue();
        for (String mixinName : components = value != null ? value.split(",") : ArrayUtil.EMPTY_STRING_ARRAY) {
            Mixin mixin = tapestryProject.findMixin(mixinName);
            if (mixin == null) continue;
            result.add(mixin);
        }
        ArrayList<Mixin> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/descriptor/DescriptorUtil", "findMixins"));
        }
        return arrayList;
    }
}

