/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.tapestry.core.model.externalizable.documentation.Home;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.TapestryIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class DocumentationTab {
    private JButton _homeButton;
    private JButton _reloadButton;
    private JButton _backButton;
    private JButton _forwardButton;
    private JButton _goButton;
    private JTextField _text;
    private JButton _docButton;
    private JPanel _mainPanel;
    private static final Logger _logger = Logger.getLogger(DocumentationTab.class);
    private JButton _classButton;
    private Project _project;
    private Object _element;

    public DocumentationTab(Project project) {
        this._project = project;
        this.$$$setupUI$$$();
        this._homeButton.setIcon(TapestryIcons.House);
        this._backButton.setIcon(TapestryIcons.Arrow_left);
        this._forwardButton.setIcon(TapestryIcons.Arrow_right);
        this._reloadButton.setIcon(AllIcons.Actions.Refresh);
        this._goButton.setIcon(TapestryIcons.Bullet_go);
        this._backButton.setVisible(false);
        this._forwardButton.setVisible(false);
        this._reloadButton.setVisible(false);
        this._goButton.setVisible(false);
        this._docButton.setVisible(false);
        this._text.setText("ldp:Home");
        try {
            this.showDocumentation(null, project);
        }
        catch (Exception ex) {
            _logger.error((Object)"Error parsing documentation HTML with cobra", (Throwable)ex);
        }
        this._homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationTab.this.showDocumentation(null, DocumentationTab.this._project);
            }
        });
        this._classButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationTab.this.navigateToClass();
            }
        });
    }

    public JComponent getMainPanel() {
        return this._mainPanel;
    }

    protected void navigateToClass() {
        PresentationLibraryElement elementType = (PresentationLibraryElement)this._element;
        if (this._element != null) {
            FileEditorManager.getInstance((Project)this._project).openFile(((IntellijJavaClassType)elementType.getElementClass()).getPsiClass().getContainingFile().getVirtualFile(), true);
        }
    }

    protected void setElement(Object element) {
        this._element = element;
    }

    protected void showDocumentation(Object element, Project project) {
        String text;
        if (element == null) {
            this._classButton.setEnabled(false);
            this._text.setText("ldp://Home");
            try {
                ArrayList<String> moduleNames = new ArrayList<String>();
                for (Module module : TapestryUtils.getAllTapestryModules(project)) {
                    moduleNames.add(module.getName());
                }
                text = new Home(moduleNames).getDocumentation();
            }
            catch (Exception ex) {
                text = null;
            }
        } else {
            this._classButton.setEnabled(true);
            PresentationLibraryElement elementType = (PresentationLibraryElement)element;
            String library = elementType.getLibrary().getId();
            if (library.equals("application")) {
                this._text.setText("ldp://App : " + elementType.getElementClass().getFullyQualifiedName());
            } else {
                this._text.setText("ldp://Lib : " + library + " : " + elementType.getElementClass().getFullyQualifiedName());
            }
            try {
                text = elementType.getDocumentation();
            }
            catch (Exception e) {
                text = null;
            }
        }
        if (text != null) {
            Object var4_3 = null;
        } else {
            this.clear();
        }
    }

    protected void clear() {
    }

    protected List<String> getModules(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList<String> nameOfModules = new ArrayList<String>();
        for (Module module : modules) {
            nameOfModules.add(module.getName());
        }
        return nameOfModules;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JTextField jTextField;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JPanel jPanel;
        this._mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jPanel.add((Component)jToolBar, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, new Dimension(-1, 20), null));
        this._homeButton = jButton7 = new JButton();
        jButton7.setText("Home");
        Component component = jToolBar.add(jButton7);
        this._reloadButton = jButton6 = new JButton();
        jButton6.setText("");
        Component component2 = jToolBar.add(jButton6);
        this._backButton = jButton5 = new JButton();
        jButton5.setText("");
        Component component3 = jToolBar.add(jButton5);
        this._forwardButton = jButton4 = new JButton();
        jButton4.setText("");
        Component component4 = jToolBar.add(jButton4);
        this._text = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jTextField.setInheritsPopupMenu(true);
        jTextField.setMinimumSize(new Dimension(490, 21));
        jTextField.setMaximumSize(new Dimension(490, 21));
        jTextField.setEditable(false);
        jTextField.setText("");
        ((Component)jTextField).setBackground(new Color(-37));
        ((Component)jTextField).setFont(new Font("SansSerif", 1, 11));
        jTextField.setFocusable(false);
        jTextField.setPreferredSize(new Dimension(490, 21));
        Component component5 = jToolBar.add(jTextField);
        this._goButton = jButton3 = new JButton();
        jButton3.setText("");
        ((Component)jButton3).setEnabled(false);
        Component component6 = jToolBar.add(jButton3);
        Spacer spacer = new Spacer();
        Component component7 = jToolBar.add((Component)spacer);
        this._classButton = jButton2 = new JButton();
        jButton2.setText("GoTo Class");
        Component component8 = jToolBar.add(jButton2);
        this._docButton = jButton = new JButton();
        jButton.setText("Doc");
        ((Component)jButton).setEnabled(false);
        Component component9 = jToolBar.add(jButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._mainPanel;
    }
}

