/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlLoopVariable;
import com.intellij.velocity.psi.VtlOperatorExpression;
import com.intellij.velocity.psi.VtlRangeExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlTypesInspection
extends VtlInspectionBase {
    private static void checkRangeBound(PsiElement element, ProblemsHolder holder, @Nullable VtlExpression bound) {
        if (bound == null) {
            return;
        }
        PsiType type = bound.getPsiType();
        if (type == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiType)PsiUtil.getBoxedType(type, element), (String)"java.lang.Integer")) {
            holder.registerProblem((PsiElement)bound, "Range bound should be integer", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        if (element instanceof VtlOperatorExpression) {
            VtlOperatorExpression expression = (VtlOperatorExpression)element;
            if (expression.getPsiType() != null) {
                return;
            }
            String message = expression.getIndefiniteTypeMessage();
            if (message != null) {
                holder.registerProblem((PsiElement)expression, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        } else if (element instanceof VtlLoopVariable) {
            VtlLoopVariable loopVariable = (VtlLoopVariable)element;
            if (loopVariable.getPsiType() != null) {
                return;
            }
            VtlExpression expression = loopVariable.getIterableExpression();
            if (expression == null) {
                return;
            }
            PsiType type = expression.getPsiType();
            if (type == null) {
                return;
            }
            String typeName = PsiUtil.getPresentableText(type);
            holder.registerProblem((PsiElement)expression, VelocityBundle.message("illegal.iterable.expression.type", typeName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (element instanceof VtlRangeExpression) {
            VtlTypesInspection.checkRangeBound(element, holder, ((VtlRangeExpression)element).getLowerBound());
            VtlTypesInspection.checkRangeBound(element, holder, ((VtlRangeExpression)element).getUpperBound());
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = VelocityBundle.message("vtl.types.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/VtlTypesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("VtlTypesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/VtlTypesInspection", "getShortName"));
        }
        return "VtlTypesInspection";
    }
}

