/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring.moveClass;

import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.javascript.flex.refactoring.moveClass.FlexMoveClassProcessor;
import com.intellij.javascript.flex.refactoring.moveClass.FlexMoveInnerClassProcessor;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class FlexMoveClassDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance((String)FlexMoveClassDialog.class.getName());
    private JLabel myElementLabel;
    private JSReferenceEditor myTargetPackageField;
    private JPanel myContentPane;
    private NonFocusableCheckBox myCbSearchInComments;
    private NonFocusableCheckBox myCbSearchTextOccurences;
    private NonFocusableCheckBox myCbMoveToAnotherSourceFolder;
    private JLabel myPackageLabel;
    private JTextField myClassNameField;
    private JLabel myClassNameLabel;
    private final Project myProject;
    private final Collection<JSQualifiedNamedElement> myElements;
    @Nullable
    private final PsiElement myTargetContainer;
    @Nullable
    private final MoveCallback myCallback;
    private final boolean myFileLocal;

    public FlexMoveClassDialog(Project project, Collection<JSQualifiedNamedElement> elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        super(project, true);
        boolean canMoveToDifferentSourceRoot;
        this.myProject = project;
        this.myElements = elements;
        this.myTargetContainer = targetContainer;
        this.myCallback = callback;
        this.$$$setupUI$$$();
        JSQualifiedNamedElement firstElement = this.myElements.iterator().next();
        this.myFileLocal = JSResolveUtil.isFileLocalSymbol((PsiElement)firstElement);
        this.setSize(500, 130);
        if (this.myFileLocal) {
            LOG.assertTrue(this.myElements.size() == 1);
            this.myClassNameLabel.setVisible(true);
            this.myClassNameLabel.setText(FlexBundle.message("element.name", JSBundle.message((String)JSNamedElementKind.kind((JSNamedElement)firstElement).humanReadableKey(), (Object[])new Object[0])));
            this.myClassNameField.setVisible(true);
            this.myClassNameField.setText(this.myElements.iterator().next().getName());
            this.myClassNameField.selectAll();
            this.myPackageLabel.setText(FlexBundle.message("package.name.title", new Object[0]));
            this.setTitle(RefactoringBundle.message((String)"move.inner.to.upper.level.title"));
        } else {
            this.myClassNameLabel.setVisible(false);
            this.myClassNameField.setVisible(false);
            this.myPackageLabel.setText(FlexBundle.message("to.package.title", new Object[0]));
            this.setTitle(RefactoringBundle.message((String)"move.title"));
        }
        this.myElementLabel.setLabelFor(this.myTargetPackageField.getChildComponent());
        String labelText = elements.size() == 1 ? FlexBundle.message(this.myFileLocal ? "move.file.local.0" : "move.0", StringUtil.decapitalize((String)JSBundle.message((String)JSNamedElementKind.kind((JSNamedElement)firstElement).humanReadableKey(), (Object[])new Object[0])), firstElement.getQualifiedName()) : FlexBundle.message("move.elements", new Object[0]);
        this.myElementLabel.setText(labelText);
        this.myPackageLabel.setLabelFor(this.myTargetPackageField.getChildComponent());
        this.init();
        boolean bl = canMoveToDifferentSourceRoot = !this.myFileLocal && ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots().length > 1;
        if (canMoveToDifferentSourceRoot) {
            this.myCbMoveToAnotherSourceFolder.setEnabled(true);
        } else {
            this.myCbMoveToAnotherSourceFolder.setEnabled(false);
            this.myCbMoveToAnotherSourceFolder.setSelected(false);
        }
        this.myClassNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                FlexMoveClassDialog.this.validateButtons();
            }
        });
        this.myTargetPackageField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                FlexMoveClassDialog.this.validateButtons();
            }
        });
    }

    protected void canRun() throws ConfigurationException {
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
        if (this.myFileLocal) {
            String className = this.myClassNameField.getText();
            if (StringUtil.isEmpty((String)className)) {
                throw new ConfigurationException(FlexBundle.message("element.name.empty", JSBundle.message((String)JSNamedElementKind.kind((JSNamedElement)((JSNamedElement)this.myElements.iterator().next())).humanReadableKey(), (Object[])new Object[0])));
            }
            if (!namesValidator.isIdentifier(className, this.myProject)) {
                throw new ConfigurationException(FlexBundle.message("invalid.element.name", StringUtil.decapitalize((String)JSBundle.message((String)JSNamedElementKind.kind((JSNamedElement)((JSNamedElement)this.myElements.iterator().next())).humanReadableKey(), (Object[])new Object[0])), className));
            }
        }
        String packageName = this.myTargetPackageField.getText();
        for (String s : StringUtil.split((String)packageName, (String)".")) {
            if (namesValidator.isIdentifier(s, this.myProject)) continue;
            throw new ConfigurationException(JSBundle.message((String)"invalid.package", (Object[])new Object[]{packageName}));
        }
    }

    private void createUIComponents() {
        String initialPackage = this.myTargetContainer instanceof PsiDirectoryContainer ? DirectoryIndex.getInstance((Project)this.myProject).getPackageName(((PsiDirectoryContainer)this.myTargetContainer).getDirectories()[0].getVirtualFile()) : (this.myTargetContainer instanceof PsiDirectory ? DirectoryIndex.getInstance((Project)this.myProject).getPackageName(((PsiDirectory)this.myTargetContainer).getVirtualFile()) : (this.myFileLocal ? StringUtil.getPackageName((String)this.myElements.iterator().next().getQualifiedName()) : JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)this.myElements.iterator().next().getContainingFile().getVirtualFile(), (Project)this.myProject)));
        this.myTargetPackageField = JSReferenceEditor.forPackageName((String)initialPackage, (Project)this.myProject, (String)(FlexMoveClassDialog.class.getName() + ".target_package"), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (String)RefactoringBundle.message((String)"choose.destination.package"));
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameField.isVisible() ? this.myClassNameField : this.myTargetPackageField.getChildComponent();
    }

    protected String getDimensionServiceKey() {
        return FlexMoveClassDialog.class.getName();
    }

    protected void doAction() {
        this.myTargetPackageField.updateRecents();
        PsiElement firstElement = (PsiElement)this.myElements.iterator().next();
        PsiDirectory baseDir = this.myTargetContainer instanceof PsiDirectory ? (PsiDirectory)this.myTargetContainer : PlatformPackageUtil.getDirectory((PsiElement)firstElement);
        String nameToCheck = this.myFileLocal ? this.myClassNameField.getText() : null;
        PsiDirectory targetDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass((Project)this.myProject, (Module)ModuleUtil.findModuleForPsiElement((PsiElement)firstElement), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (String)this.myTargetPackageField.getText(), (String)nameToCheck, (PsiDirectory)baseDir, (ThreeState)(this.myCbMoveToAnotherSourceFolder.isSelected() ? ThreeState.YES : ThreeState.NO));
        if (targetDirectory == null) {
            return;
        }
        if (!this.myFileLocal) {
            try {
                for (PsiElement psiElement : this.myElements) {
                    MoveFilesOrDirectoriesUtil.checkMove((PsiElement)psiElement.getContainingFile(), (PsiElement)targetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), (String)this.getHelpId(), (Project)this.myProject);
                return;
            }
        }
        Object processor = this.myFileLocal ? new FlexMoveInnerClassProcessor(this.myElements.iterator().next(), targetDirectory, this.myClassNameField.getText(), this.myTargetPackageField.getText(), this.myCbSearchInComments.isSelected(), this.myCbSearchTextOccurences.isSelected(), this.myCallback) : new FlexMoveClassProcessor(this.myElements, targetDirectory, this.myTargetPackageField.getText(), this.myCbSearchInComments.isSelected(), this.myCbSearchTextOccurences.isSelected(), this.myCallback);
        this.invokeRefactoring((BaseRefactoringProcessor)processor);
    }

    protected String getHelpId() {
        return this.myFileLocal ? "Move_Inner_to_Upper_Level_Dialog_for_ActionScript" : "refactoring.moveClass";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        NonFocusableCheckBox nonFocusableCheckBox;
        NonFocusableCheckBox nonFocusableCheckBox2;
        NonFocusableCheckBox nonFocusableCheckBox3;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myElementLabel = jLabel3 = new JLabel();
        jLabel3.setText("Move class 'Foo'");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myPackageLabel = jLabel2 = new JLabel();
        jLabel2.setText("To package:");
        jLabel2.setDisplayedMnemonic('G');
        jLabel2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSReferenceEditor jSReferenceEditor = this.myTargetPackageField;
        jPanel.add((Component)jSReferenceEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCbSearchInComments = nonFocusableCheckBox3 = new NonFocusableCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        nonFocusableCheckBox3.setSelected(true);
        nonFocusableCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jPanel2.add((Component)nonFocusableCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        this.myCbSearchTextOccurences = nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        nonFocusableCheckBox2.setSelected(true);
        jPanel2.add((Component)nonFocusableCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 3, 3, 3, null, null, null));
        this.myCbMoveToAnotherSourceFolder = nonFocusableCheckBox = new NonFocusableCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.classes.move.to.another.source.folder"));
        nonFocusableCheckBox.setSelected(true);
        nonFocusableCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jPanel2.add((Component)nonFocusableCheckBox, new GridConstraints(1, 0, 1, 2, 8, 3, 3, 3, null, null, null));
        this.myClassNameLabel = jLabel = new JLabel();
        jLabel.setText("Class name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

