/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptTypeEvaluator
extends JSTypeEvaluator {
    private static final String REPEATER_CLASS_FQN = "mx.core.Repeater";

    public ActionScriptTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor, boolean ecma) {
        super(context, processor, ecma);
    }

    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof JSPackageWrapper) {
            JSReferenceExpression expression = this.myContext.getProcessedExpression();
            if (this.myTypeProcessor instanceof PsiScopeProcessor && expression != null) {
                if (this.myTypeProcessor instanceof ResolveProcessor) {
                    ((ResolveProcessor)this.myTypeProcessor).prefixResolved();
                }
                resolveResult.processDeclarations((PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), (PsiElement)expression, (PsiElement)expression);
            } else {
                this.addType(((JSQualifiedNamedElement)resolveResult).getQualifiedName(), resolveResult);
            }
            return true;
        }
        return false;
    }

    protected void evaluateNewExpressionTypes(JSNewExpression newExpression) {
        JSExpression methodExpr = newExpression.getMethodExpression();
        if (methodExpr != null) {
            if (methodExpr instanceof JSArrayLiteralExpression) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)methodExpr);
                JSType type = JSNamedType.createType((String)"Vector", (JSTypeSource)source, (JSContext)JSContext.INSTANCE);
                PsiElement arrayInitializingType = newExpression.getArrayInitializingType();
                if (arrayInitializingType != null) {
                    JSType argType = JSTypeUtils.createType((String)JSImportHandlingUtil.resolveTypeName((String)arrayInitializingType.getText(), (PsiElement)newExpression), (JSTypeSource)source);
                    type = new JSGenericTypeImpl(source, type, argType);
                }
                this.addType(type, (PsiElement)methodExpr);
            } else {
                JSAnyType type = JSAnyType.get((PsiElement)methodExpr, (boolean)false);
                if (methodExpr instanceof JSReferenceExpression) {
                    JSType typeFromText;
                    PsiElement resolve = ((JSReferenceExpression)methodExpr).resolve();
                    if (JSResolveUtil.isConstructorFunction((PsiElement)resolve) && resolve.getParent() instanceof JSClass) {
                        resolve = resolve.getParent();
                    }
                    if ((resolve instanceof JSClass || resolve == null) && (typeFromText = JSTypeUtils.createType((String)methodExpr.getText(), (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)methodExpr, (boolean)false))) != null) {
                        type = typeFromText;
                    }
                }
                this.addType((JSType)type, (PsiElement)methodExpr);
            }
        }
    }

    protected void addTypeFromClass(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        JSApplyContextElement peek;
        JSTypeSource source;
        String psiElementType;
        JSType type;
        JSReferenceExpression expression;
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/javascript/flex/resolve/ActionScriptTypeEvaluator", "addTypeFromClass"));
        }
        if (resolveResult instanceof JSFunction) {
            resolveResult = resolveResult.getParent();
        }
        if ((expression = this.myContext.getProcessedExpression()) == null) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof JSExpression) {
            parent = JSUtils.unparenthesize((JSExpression)((JSExpression)parent));
        }
        if (JSTypeUtils.isActionScriptVectorType((JSType)(type = JSNamedType.createType((String)(psiElementType = parent instanceof JSReferenceExpression || JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)expression) || PsiTreeUtil.getChildOfType((PsiElement)expression, JSE4XNamespaceReference.class) != null || parent instanceof JSCallExpression ? ((JSClass)resolveResult).getQualifiedName() : "Class"), (JSTypeSource)(source = JSTypeSourceFactory.createTypeSource((PsiElement)expression)), (JSContext)JSContext.UNKNOWN)))) {
            type = JSTypeUtils.createType((String)JSImportHandlingUtil.resolveTypeName((String)expression.getText(), (PsiElement)expression), (JSTypeSource)source);
        }
        if ((peek = this.myContext.peekJSElementToApply()) instanceof JSApplyCallElement) {
            this.myContext.popJSElementToApply();
        }
        this.addType(type, resolveResult);
        if (peek instanceof JSApplyCallElement) {
            this.myContext.pushJSElementToApply(peek);
        }
    }

    protected boolean useVariableType(JSType type) {
        return this.myContext.isJSElementsToApplyEmpty() && super.useVariableType(type);
    }

    protected boolean addTypeFromElementResolveResult(PsiElement resolveResult, boolean hasSomeType) {
        if (resolveResult instanceof JSOffsetBasedImplicitElement && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)resolveResult.getContainingFile())) {
            resolveResult = ((JSOffsetBasedImplicitElement)resolveResult).getElementAtOffset();
        }
        if (resolveResult instanceof XmlToken) {
            XmlToken xmlToken = (XmlToken)resolveResult;
            XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)xmlToken, XmlAttribute.class);
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlToken, XmlTag.class);
            if (xmlToken.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && xmlAttribute != null && "id".equals(xmlAttribute.getName()) && xmlTag != null && ActionScriptTypeEvaluator.isInsideRepeaterTag(xmlTag)) {
                PsiElement arrayClass = ActionScriptClassResolver.findClassByQNameStatic("Array", (PsiElement)xmlToken);
                if (arrayClass != null) {
                    JSPrimitiveArrayType type;
                    String arrayType = new JSTagContextBuilder((PsiElement)resolveResult, null).typeName;
                    JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult);
                    if (arrayType != null) {
                        JSType baseType = JSNamedType.createType((String)arrayType, (JSTypeSource)source, (JSContext)JSContext.INSTANCE);
                        type = new JSArrayTypeImpl(baseType, source);
                    } else {
                        type = new JSPrimitiveArrayType(source, JSTypeContext.INSTANCE);
                    }
                    this.addType((JSType)type, arrayClass);
                }
            } else {
                String name;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)resolveResult, XmlTag.class, (boolean)false);
                JSClass clazz = JSResolveUtil.getClassFromTagNameInMxml((PsiElement)tag);
                if (clazz != null && (name = clazz.getQualifiedName()) != null) {
                    this.addType(name, (PsiElement)clazz);
                }
            }
            return hasSomeType;
        }
        return super.addTypeFromElementResolveResult(resolveResult, hasSomeType);
    }

    private static boolean isInsideRepeaterTag(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/javascript/flex/resolve/ActionScriptTypeEvaluator", "isInsideRepeaterTag"));
        }
        XmlTag parent = xmlTag;
        while ((parent = parent.getParent()) instanceof XmlTag) {
            if (!REPEATER_CLASS_FQN.equals(new JSTagContextBuilder((PsiElement)parent, (String)"").typeName)) continue;
            return true;
        }
        return false;
    }

    public void addType(@Nullable JSType _type, @Nullable PsiElement source) {
        JSClass jsClass;
        if (_type != null && this.myContext.isJSElementsToApplyEmpty() && (source == null || source == EXPLICIT_TYPE_MARKER_ELEMENT) && (jsClass = (JSClass)JSInheritanceUtil.withEnforcedScope(() -> _type.resolveClass(), (GlobalSearchScope)JSResolveUtil.getResolveScope((PsiElement)this.myContext.targetFile))) != null) {
            source = jsClass;
        }
        super.addType(_type, source);
    }
}

