/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.airpackage.AdtPackageTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageProjectParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalTask {
    private static final Logger LOG = Logger.getInstance((String)ExternalTask.class.getName());
    protected final Project myProject;
    protected final Sdk myFlexSdk;
    private Process myProcess;
    private boolean myFinished;
    private String myCommandLine = "";
    protected List<String> myMessages = new ArrayList<String>();
    private int myExitCode = -1;

    public ExternalTask(Project project, Sdk flexSdk) {
        this.myProject = project;
        this.myFlexSdk = flexSdk;
    }

    public void start() {
        List<String> command = this.createCommandLine();
        for (String s : command) {
            if (s != null) continue;
            LOG.error(StringUtil.join(command, s1 -> s1 == null ? "null" : s1, (String)" "));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(this.getProcessDir());
        this.myCommandLine = StringUtil.join(command, (String)" ");
        this.debug("Executing task: " + this.myCommandLine);
        try {
            this.myProcess = processBuilder.start();
            this.scheduleInputStreamReading();
        }
        catch (IOException e) {
            this.myFinished = true;
            this.myMessages.add(e.getMessage());
        }
    }

    @Nullable
    protected File getProcessDir() {
        return null;
    }

    private void debug(String message) {
        LOG.debug("[" + this.hashCode() + "] " + message);
    }

    protected abstract List<String> createCommandLine();

    protected boolean checkMessages() {
        return this.myMessages.isEmpty();
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public void cancel() {
        if (this.myProcess != null) {
            this.myProcess.destroy();
            try {
                this.myExitCode = this.myProcess.exitValue();
                this.debug("Process complete with exit code " + this.myExitCode);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        this.myFinished = true;
    }

    public String getCommandLine() {
        return this.myCommandLine;
    }

    public List<String> getMessages() {
        return this.myMessages;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    protected Process getProcess() {
        return this.myProcess;
    }

    protected void scheduleInputStreamReading() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean usageStarted = false;
            InputStreamReader reader = FlexCommonUtils.createInputStreamReader((InputStream)this.myProcess.getInputStream());
            try {
                int read;
                char[] buf = new char[4096];
                block11: while ((read = reader.read(buf, 0, buf.length)) >= 0) {
                    String output = new String(buf, 0, read);
                    this.debug("Process output: " + output);
                    if (usageStarted) continue;
                    StringTokenizer tokenizer = new StringTokenizer(output, "\r\n");
                    while (tokenizer.hasMoreElements()) {
                        String message = tokenizer.nextElement();
                        if (StringUtil.isEmptyOrSpaces((String)message)) continue;
                        if (message.trim().toLowerCase().startsWith("usage:")) {
                            usageStarted = true;
                            continue block11;
                        }
                        if (message.trim().endsWith("password:")) {
                            OutputStream outputStream = this.myProcess.getOutputStream();
                            outputStream.write("\n".getBytes());
                            outputStream.flush();
                            continue;
                        }
                        this.myMessages.add(message);
                    }
                }
            }
            catch (IOException e) {
                this.myMessages.add(e.getMessage());
            }
            finally {
                this.cancel();
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        });
    }

    public static boolean runWithProgress(ExternalTask task, String progressTitle, String frameTitle) {
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(ExternalTask.createRunnable(task), progressTitle, true, task.myProject) && ExternalTask.checkMessages(task, frameTitle);
    }

    public static void runInBackground(final ExternalTask task, String progressTitle, final @Nullable Consumer<List<String>> onSuccess, final @Nullable Consumer<List<String>> onFailure) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(task.myProject, progressTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/flex/actions/ExternalTask$1", "run"));
                }
                ExternalTask.createRunnable(task).run();
            }

            public void onSuccess() {
                if (task.checkMessages()) {
                    if (onSuccess != null) {
                        ApplicationManager.getApplication().invokeLater(() -> onSuccess.consume(task.getMessages()));
                    }
                } else if (onFailure != null) {
                    ApplicationManager.getApplication().invokeLater(() -> onFailure.consume(task.getMessages()));
                }
            }
        });
    }

    private static boolean checkMessages(ExternalTask task, String frameTitle) {
        String message;
        List<String> messages = task.getMessages();
        if (task.checkMessages()) {
            return true;
        }
        String string = message = messages.isEmpty() ? FlexBundle.message("unexpected.empty.adt.output", new Object[0]) : StringUtil.join(messages, (String)"\n");
        if (message.length() > 1000) {
            message = message.substring(0, 1000) + "...";
        }
        if (task instanceof AdtPackageTask) {
            message = message + "\n\nADT command line:\n" + task.getCommandLine();
        }
        Messages.showErrorDialog((Project)task.myProject, (String)message, (String)frameTitle);
        return false;
    }

    private static Runnable createRunnable(ExternalTask task) {
        return () -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            try {
                AirPackageProjectParameters.getInstance(task.myProject).setPackagingInProgress(true);
                task.start();
                while (!task.isFinished()) {
                    if (indicator != null && indicator.isCanceled()) {
                        task.cancel();
                        break;
                    }
                    TimeoutUtil.sleep((long)200L);
                }
            }
            finally {
                AirPackageProjectParameters.getInstance(task.myProject).setPackagingInProgress(false);
            }
        };
    }
}

