/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.build.FlashProjectStructureProblem;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.ValidateFlashConfigurationsPrecompileTask;
import com.intellij.lang.javascript.flex.projectStructure.FlexBCConfigurator;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.PlaceInBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.ui.UsageInBcDependencies;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildConfigurationProjectStructureElement
extends ProjectStructureElement {
    private final ModifiableFlexBuildConfiguration myBc;
    private final Module myModule;

    public BuildConfigurationProjectStructureElement(ModifiableFlexBuildConfiguration bc, Module module, @NotNull StructureConfigurableContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/flex/projectStructure/ui/BuildConfigurationProjectStructureElement", "<init>"));
        }
        super(context);
        this.myBc = bc;
        this.myModule = module;
    }

    public String getPresentableName() {
        return this.myBc.getName();
    }

    public String getPresentableText() {
        return FlexCommonBundle.message((String)"bc.0.module.1", (Object[])new Object[]{this.myBc.getName(), this.myModule.getName()});
    }

    public String getTypeName() {
        return FlexBundle.message("bc.structure.element.type.name", new Object[0]);
    }

    public String getId() {
        return "flex_bc:" + this.myBc.getName() + "\t" + this.myModule.getName();
    }

    public void check(ProjectStructureProblemsHolder problemsHolder) {
        FlexBCConfigurator configurator = FlexBuildConfigurationsExtension.getInstance().getConfigurator();
        FlexProjectConfigurationEditor editor = configurator.getConfigEditor();
        assert (editor != null);
        this.checkDependencies(problemsHolder, editor);
        this.checkSameOutputPaths(problemsHolder, configurator, editor);
        this.checkIfBCOutputUsedAs3rdPartyLib(problemsHolder, configurator, editor);
        ValidateFlashConfigurationsPrecompileTask.checkConfiguration(this.myModule, this.myBc, true, (Consumer<FlashProjectStructureProblem>)((Consumer)problem -> {
            if (!(problem instanceof FlashProjectStructureProblem.FlexUnitOutputFolderProblem)) {
                PlaceInBuildConfiguration place = new PlaceInBuildConfiguration(this, problem.tabName, problem.locationOnTab);
                ProjectStructureProblemType problemType = problem.severity == ProjectStructureProblemType.Severity.ERROR ? ProjectStructureProblemType.error((String)problem.errorId) : ProjectStructureProblemType.warning((String)problem.errorId);
                problemsHolder.registerProblem(problem.errorMessage, null, problemType, (PlaceInProjectStructure)place, null);
            }
        }));
    }

    private void checkDependencies(ProjectStructureProblemsHolder problemsHolder, FlexProjectConfigurationEditor editor) {
        ModulesConfigurator modulesConfigurator = this.myContext.getModulesConfigurator();
        for (DependencyEntry entry : this.myBc.getDependencies().getEntries()) {
            if (!(entry instanceof BuildConfigurationEntry)) continue;
            String moduleName = ((BuildConfigurationEntry)entry).getModuleName();
            String bcName = ((BuildConfigurationEntry)entry).getBcName();
            Module module = modulesConfigurator.getModule(moduleName);
            String errorMessage = null;
            if (module == null) {
                errorMessage = FlexBundle.message("bc.problem.dependency.module.not.found", moduleName);
            } else if (ContainerUtil.find((Object[])editor.getConfigurations(module), configuration -> bcName.equals(configuration.getName())) == null) {
                errorMessage = FlexBundle.message("bc.problem.dependency.bc.not.found", bcName, moduleName);
            }
            if (errorMessage == null) continue;
            DependenciesConfigurable.Location.TableEntry location = DependenciesConfigurable.Location.TableEntry.forBc(moduleName, bcName);
            PlaceInBuildConfiguration place = new PlaceInBuildConfiguration(this, DependenciesConfigurable.TAB_NAME, location);
            problemsHolder.registerProblem(errorMessage, null, ProjectStructureProblemType.error((String)"flex-bc-dependency-bc"), (PlaceInProjectStructure)place, null);
        }
    }

    private void checkSameOutputPaths(ProjectStructureProblemsHolder problemsHolder, FlexBCConfigurator configurator, FlexProjectConfigurationEditor editor) {
        String outputPath = this.myBc.getActualOutputFilePath();
        List<ModifiableFlexBuildConfiguration> bcs = configurator.getBCsByOutputPath(outputPath);
        if (bcs != null && bcs.size() > 1) {
            StringBuilder buf = new StringBuilder();
            for (ModifiableFlexBuildConfiguration bc : bcs) {
                if (bc == this.myBc) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(FlexBundle.message("0.module.1", bc.getName(), editor.getModule(bc).getName()));
            }
            String message = FlexBundle.message("same.output.files.as.in.bcs", bcs.size() - 1, buf.toString(), FileUtil.toSystemDependentName((String)outputPath));
            FlexBCConfigurable.Location location = FlexBCConfigurable.Location.OutputFileName;
            PlaceInBuildConfiguration placeInPS = new PlaceInBuildConfiguration(this, this.myBc.getName(), (Object)location);
            problemsHolder.registerProblem(message, null, ProjectStructureProblemType.warning((String)location.errorId), (PlaceInProjectStructure)placeInPS, null);
        }
    }

    private void checkIfBCOutputUsedAs3rdPartyLib(ProjectStructureProblemsHolder problemsHolder, FlexBCConfigurator configurator, FlexProjectConfigurationEditor editor) {
        for (DependencyEntry entry : this.myBc.getDependencies().getEntries()) {
            Library library;
            if (entry instanceof ModuleLibraryEntry) {
                LibraryOrderEntry orderEntry = FlexProjectRootsUtil.findOrderEntry((ModuleLibraryEntry)entry, (ModuleRootModel)editor.getModifiableRootModel(this.myModule));
                if (orderEntry == null) continue;
                this.checkIfBCOutputUsedAs3rdPartyLib(problemsHolder, configurator, entry, orderEntry.getRootFiles(OrderRootType.CLASSES));
                continue;
            }
            if (!(entry instanceof SharedLibraryEntry) || (library = FlexProjectRootsUtil.findOrderEntry(this.myModule.getProject(), (SharedLibraryEntry)entry)) == null) continue;
            this.checkIfBCOutputUsedAs3rdPartyLib(problemsHolder, configurator, entry, library.getFiles(OrderRootType.CLASSES));
        }
    }

    private void checkIfBCOutputUsedAs3rdPartyLib(ProjectStructureProblemsHolder problemsHolder, final FlexBCConfigurator configurator, final DependencyEntry entry, VirtualFile[] classesRoots) {
        for (VirtualFile libFile : classesRoots) {
            List<ModifiableFlexBuildConfiguration> bcs;
            VirtualFile realFile = FlexCompilerHandler.getRealFile(libFile);
            if (realFile == null || realFile.isDirectory() || !"swc".equalsIgnoreCase(realFile.getExtension()) || (bcs = configurator.getBCsByOutputPath(realFile.getPath())) == null || bcs.isEmpty()) continue;
            final ModifiableFlexBuildConfiguration otherLibBC = bcs.get(0);
            FlexProjectConfigurationEditor editor = configurator.getConfigEditor();
            assert (editor != null);
            Module otherLibModule = editor.getModule(otherLibBC);
            String message = FlexBundle.message("own.lib.used.as.3rd.party", realFile.getName(), otherLibBC.getName(), otherLibModule.getName());
            DependenciesConfigurable.Location.TableEntry location = entry instanceof ModuleLibraryEntry ? DependenciesConfigurable.Location.TableEntry.forModuleLibrary(((ModuleLibraryEntry)entry).getLibraryId()) : DependenciesConfigurable.Location.TableEntry.forSharedLibrary(((SharedLibraryEntry)entry).getLibraryLevel(), ((SharedLibraryEntry)entry).getLibraryName());
            PlaceInBuildConfiguration placeInPS = new PlaceInBuildConfiguration(this, DependenciesConfigurable.TAB_NAME, location);
            String quickFixName = FlexBundle.message("instead.setup.dependency.on.bc", otherLibBC.getName(), otherLibModule.getName());
            ConfigurationErrorQuickFix quickFix = new ConfigurationErrorQuickFix(quickFixName){

                public void performFix() {
                    FlexBCConfigurable configurable = configurator.getBCConfigurable(BuildConfigurationProjectStructureElement.this.myBc);
                    DependenciesConfigurable dependenciesConfigurable = configurable.getDependenciesConfigurable();
                    FlexBCConfigurable otherLibConfigurable = configurator.getBCConfigurable(otherLibBC);
                    LinkageType linkageType = entry.getDependencyType().getLinkageType();
                    dependenciesConfigurable.addBCDependency(otherLibConfigurable, linkageType);
                    if (entry instanceof ModuleLibraryEntry) {
                        dependenciesConfigurable.removeDependency(((ModuleLibraryEntry)entry).getLibraryId());
                    } else {
                        dependenciesConfigurable.removeDependency(((SharedLibraryEntry)entry).getLibraryLevel(), ((SharedLibraryEntry)entry).getLibraryName());
                    }
                    Place place = configurator.getPlaceFor(BuildConfigurationProjectStructureElement.this.myModule, BuildConfigurationProjectStructureElement.this.myBc.getName());
                    place.putPath("tabName", (Object)DependenciesConfigurable.TAB_NAME);
                    place.putPath("FlashBuildConfiguration.locationOnTab", (Object)DependenciesConfigurable.Location.TableEntry.forBc(otherLibConfigurable));
                    ProjectStructureConfigurable.getInstance((Project)BuildConfigurationProjectStructureElement.this.myModule.getProject()).navigateTo(place, true);
                }
            };
            String errorId = entry instanceof ModuleLibraryEntry ? ((ModuleLibraryEntry)entry).getLibraryId() : ((SharedLibraryEntry)entry).getLibraryName();
            problemsHolder.registerProblem(message, null, ProjectStructureProblemType.warning((String)errorId), (PlaceInProjectStructure)placeInPS, quickFix);
        }
    }

    public List<ProjectStructureElementUsage> getUsagesInElement() {
        FlexBCConfigurator configurator = FlexBuildConfigurationsExtension.getInstance().getConfigurator();
        FlexProjectConfigurationEditor editor = configurator.getConfigEditor();
        assert (editor != null);
        ModulesConfigurator modulesConfigurator = this.myContext.getModulesConfigurator();
        ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>();
        for (DependencyEntry dependencyEntry : this.myBc.getDependencies().getEntries()) {
            ModifiableFlexBuildConfiguration bc;
            if (dependencyEntry instanceof SharedLibraryEntry) {
                String libraryLevel;
                String libraryName = ((SharedLibraryEntry)dependencyEntry).getLibraryName();
                final Library library = this.myContext.getLibrary(libraryName, libraryLevel = ((SharedLibraryEntry)dependencyEntry).getLibraryLevel());
                if (library == null) continue;
                usages.add(new UsageInBcDependencies(this, (ProjectStructureElement)new LibraryProjectStructureElement(this.myContext, library)){

                    public void removeSourceElement() {
                        BuildConfigurationProjectStructureElement.this.libraryReplaced(library, null);
                    }

                    public void replaceElement(ProjectStructureElement newElement) {
                        BuildConfigurationProjectStructureElement.this.libraryReplaced(library, ((LibraryProjectStructureElement)newElement).getLibrary());
                    }
                });
                continue;
            }
            if (!(dependencyEntry instanceof BuildConfigurationEntry)) continue;
            BuildConfigurationEntry bcEntry = (BuildConfigurationEntry)dependencyEntry;
            Module module = modulesConfigurator.getModule(bcEntry.getModuleName());
            if (module != null && (bc = (ModifiableFlexBuildConfiguration)ContainerUtil.find((Object[])editor.getConfigurations(module), configuration -> bcEntry.getBcName().equals(configuration.getName()))) != null) {
                usages.add(new UsageInBcDependencies(this, new BuildConfigurationProjectStructureElement(bc, module, this.myContext)){

                    public void removeSourceElement() {
                    }

                    public void replaceElement(ProjectStructureElement newElement) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            bcEntry.findBuildConfiguration();
        }
        Sdk sdk = this.myBc.getSdk();
        if (sdk != null) {
            usages.add(new UsageInBcDependencies(this, (ProjectStructureElement)new SdkProjectStructureElement(this.myContext, sdk)){

                public void removeSourceElement() {
                    BuildConfigurationProjectStructureElement.this.myBc.getDependencies().setSdkEntry(null);
                }

                public void replaceElement(ProjectStructureElement newElement) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return usages;
    }

    protected void libraryReplaced(@NotNull Library library, @Nullable Library replacement) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/javascript/flex/projectStructure/ui/BuildConfigurationProjectStructureElement", "libraryReplaced"));
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof BuildConfigurationProjectStructureElement && this.myModule.equals(((BuildConfigurationProjectStructureElement)((Object)obj)).myModule) && this.myBc.equals(((BuildConfigurationProjectStructureElement)((Object)obj)).myBc);
    }

    public int hashCode() {
        return this.myModule.hashCode() ^ this.myBc.hashCode();
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    public Module getModule() {
        return this.myModule;
    }

    public FlexBuildConfiguration getBC() {
        return this.myBc;
    }

    public String getDescription() {
        return this.myBc.getDescription();
    }
}

