/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.validation.fixes.ChoosePackageDialog;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.CreateMxmlFileIntentionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class CreateFlexMobileViewIntentionAndFix
extends CreateMxmlFileIntentionBase {
    private final boolean myAskForPackage;

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"create.mobile.view", (Object[])new Object[]{this.myClassName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateFlexMobileViewIntentionAndFix", "getText"));
        }
        return string;
    }

    public CreateFlexMobileViewIntentionAndFix(String classFqn, PsiElement element, boolean askForPackage) {
        super(classFqn, element);
        this.myAskForPackage = askForPackage;
    }

    @Override
    protected String getFileText() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<s:View xmlns:fx=\"http://ns.adobe.com/mxml/2009\" xmlns:s=\"library://ns.adobe.com/flex/spark\">\n\n</s:View>\n";
    }

    @Override
    protected Pair<String, PsiDirectory> getFileTextAndDir(@NotNull Module module) {
        PsiDirectory targetDirectory;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/validation/fixes/CreateFlexMobileViewIntentionAndFix", "getFileTextAndDir"));
        }
        if (!this.myAskForPackage) {
            return super.getFileTextAndDir(module);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    return CreateClassOrInterfaceFix.findOrCreateDirectory((String)"foo", (PsiElement)CreateFlexMobileViewIntentionAndFix.this.myElement);
                }
            });
        } else {
            ChoosePackageDialog dialog = new ChoosePackageDialog(module, this.getText(), this.myPackageName, this.myElement.getContainingFile());
            if (!dialog.showAndGet()) {
                return Pair.empty();
            }
            targetDirectory = dialog.getTargetDirectory();
        }
        return Pair.create((Object)this.getFileText(), (Object)targetDirectory);
    }
}

