/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EscapeUtils {
    private static final char ESCAPE_CHAR = '\\';

    private EscapeUtils() {
    }

    @NotNull
    public static List<String> split(@NotNull String str, char delimiterChar) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/javascript/testFramework/util/EscapeUtils", "split"));
        }
        Splitter splitter = new Splitter(str, delimiterChar);
        ArrayList out = Lists.newArrayList();
        while (splitter.hasNext()) {
            out.add(splitter.next());
        }
        ArrayList arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/EscapeUtils", "split"));
        }
        return arrayList;
    }

    @NotNull
    public static String join(@NotNull Collection<String> list, char delimiterChar) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/testFramework/util/EscapeUtils", "join"));
        }
        if (list.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/EscapeUtils", "join"));
            }
            return "";
        }
        int expectedSize = EscapeUtils.calcExpectedJoinedSize(list);
        StringBuilder out = new StringBuilder(expectedSize);
        boolean addDelimiter = false;
        for (String str : list) {
            if (addDelimiter) {
                out.append(delimiterChar);
            }
            addDelimiter = true;
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch == delimiterChar) {
                    out.append('\\').append(delimiterChar);
                    continue;
                }
                if (ch == '\\') {
                    out.append('\\').append('\\');
                    continue;
                }
                out.append(ch);
            }
        }
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/EscapeUtils", "join"));
        }
        return string;
    }

    private static int calcExpectedJoinedSize(@NotNull Collection<String> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/testFramework/util/EscapeUtils", "calcExpectedJoinedSize"));
        }
        int size = list.size() - 1;
        for (String s : list) {
            size += s.length();
        }
        return size;
    }

    private static class Splitter {
        private final String myStr;
        private final char myDelimiterChar;
        private int myInd;
        private final StringBuilder myBuffer;
        private boolean myExtraEmptyString;

        public Splitter(@NotNull String str, char delimiterChar) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/javascript/testFramework/util/EscapeUtils$Splitter", "<init>"));
            }
            this.myBuffer = new StringBuilder();
            this.myExtraEmptyString = false;
            this.myStr = str;
            this.myDelimiterChar = delimiterChar;
            this.myInd = 0;
        }

        public boolean hasNext() {
            return this.myExtraEmptyString || this.myInd < this.myStr.length();
        }

        public String next() {
            if (this.myExtraEmptyString) {
                this.myExtraEmptyString = false;
                return "";
            }
            this.myBuffer.setLength(0);
            while (this.myInd < this.myStr.length()) {
                char ch = this.myStr.charAt(this.myInd);
                if (ch == this.myDelimiterChar) {
                    ++this.myInd;
                    this.myExtraEmptyString = this.myInd == this.myStr.length();
                    return this.myBuffer.toString();
                }
                if (ch == '\\') {
                    if (this.myInd + 1 >= this.myStr.length()) {
                        throw new RuntimeException("String ends with escape char: " + this.myStr);
                    }
                    char nextChar = this.myStr.charAt(this.myInd + 1);
                    if (nextChar == '\\' || nextChar == this.myDelimiterChar) {
                        this.myBuffer.append(nextChar);
                        this.myInd += 2;
                        continue;
                    }
                    throw new RuntimeException("Unexpected char is escaped '" + nextChar + "' in " + this.myStr);
                }
                this.myBuffer.append(ch);
                ++this.myInd;
            }
            return this.myBuffer.toString();
        }
    }
}

