/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.play.console.BasicConsoleProcessRunner;
import com.intellij.play.console.ProcessLanguageConsoleViewWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BasicProcessConsoleRunnerWithHistory<T extends LanguageConsoleView> {
    private final T myConsoleView;
    private BasicConsoleProcessRunner myProcessRunner;
    private ProcessLanguageConsoleViewWrapper myComponent;

    public BasicProcessConsoleRunnerWithHistory(@NotNull T consoleView) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/play/console/BasicProcessConsoleRunnerWithHistory", "<init>"));
        }
        this.myConsoleView = consoleView;
        this.getComponent();
    }

    public void showConsoleInRunToolwindow() {
        UIUtil.invokeLaterIfNeeded(() -> this.showConsoleInnerRunToolwindow());
    }

    protected BasicConsoleProcessRunner createBasicConsoleProcessRunner() {
        return new BasicConsoleProcessRunner((LanguageConsoleView)this.myConsoleView){

            @Override
            @NotNull
            protected GeneralCommandLine createCommandLine(@NotNull String command) {
                if (command == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/play/console/BasicProcessConsoleRunnerWithHistory$1", "createCommandLine"));
                }
                GeneralCommandLine generalCommandLine = BasicProcessConsoleRunnerWithHistory.this.createCommandLine(command);
                if (generalCommandLine == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/console/BasicProcessConsoleRunnerWithHistory$1", "createCommandLine"));
                }
                return generalCommandLine;
            }

            @Override
            public String getHistoryId() {
                return BasicProcessConsoleRunnerWithHistory.this.getToolWindowId();
            }

            @Override
            public String getHistoryPersistenceId() {
                return BasicProcessConsoleRunnerWithHistory.this.getToolWindowId();
            }

            @Override
            protected JComponent getConsoleComponent() {
                return BasicProcessConsoleRunnerWithHistory.this.getComponent();
            }

            @Override
            protected OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
                if (commandLine == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/play/console/BasicProcessConsoleRunnerWithHistory$1", "createProcessHandler"));
                }
                return new ColoredProcessHandler(this.createProcess(commandLine), commandLine.getCommandLineString()){

                    protected boolean shouldDestroyProcessRecursively() {
                        return true;
                    }
                };
            }
        };
    }

    protected abstract GeneralCommandLine createCommandLine(String var1);

    public BasicConsoleProcessRunner getProcessRunner() {
        if (this.myProcessRunner == null) {
            this.myProcessRunner = this.createBasicConsoleProcessRunner();
        }
        return this.myProcessRunner;
    }

    private void showConsoleInnerRunToolwindow() {
        BasicConsoleProcessRunner processRunner = this.getProcessRunner();
        Executor executor = processRunner.getExecutor();
        ExecutionManager.getInstance((Project)this.getProject()).getContentManager().showRunContent(executor, processRunner.getContentDescriptor());
        ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow(executor.getId()).activate(() -> IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.myConsoleView.getCurrentEditor().getContentComponent(), true));
    }

    public Project getProject() {
        return this.myConsoleView.getProject();
    }

    public ProcessLanguageConsoleViewWrapper getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new ProcessLanguageConsoleViewWrapper((LanguageConsoleView)this.myConsoleView){

                @Override
                protected BasicConsoleProcessRunner getProcessRunner() {
                    return BasicProcessConsoleRunnerWithHistory.this.getProcessRunner();
                }
            };
        }
        return this.myComponent;
    }

    protected abstract String getToolWindowId();
}

