/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.play.console.BasicProcessConsoleRunnerWithHistory;
import com.intellij.play.utils.PlayBundle;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlayConsoleRunner
extends BasicProcessConsoleRunnerWithHistory<LanguageConsoleView> {
    public static final Key<Object> PLAY_CONSOLE_KEY = Key.create((String)PlayConsoleRunner.class.getSimpleName());
    private final String myPlayHome;
    private final String myWorkingDir;

    public PlayConsoleRunner(@NotNull Project project, @NotNull String playHome, @NotNull String workingDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/play/console/PlayConsoleRunner", "<init>"));
        }
        if (playHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "playHome", "com/intellij/play/console/PlayConsoleRunner", "<init>"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/play/console/PlayConsoleRunner", "<init>"));
        }
        super(PlayConsoleRunner.createConsoleView(project));
        this.myPlayHome = playHome;
        this.myWorkingDir = workingDir;
    }

    @NotNull
    private static LanguageConsoleView createConsoleView(Project project) {
        LanguageConsoleImpl consoleView = new LanguageConsoleImpl(project, PlayBundle.message("playframework", new Object[0]), (Language)PlainTextLanguage.INSTANCE);
        consoleView.getConsoleEditor().getDocument().putUserData(PLAY_CONSOLE_KEY, (Object)Boolean.TRUE);
        consoleView.setPrompt("play ");
        LanguageConsoleImpl languageConsoleImpl = consoleView;
        if (languageConsoleImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/console/PlayConsoleRunner", "createConsoleView"));
        }
        return languageConsoleImpl;
    }

    @Override
    protected GeneralCommandLine createCommandLine(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/play/console/PlayConsoleRunner", "createCommandLine"));
        }
        return new GeneralCommandLine(new String[]{PlayConsoleRunner.getExePath(this.myPlayHome)}).withParameters(PlayConsoleRunner.getParameters(command)).withEnvironment("PLAY_OPTS", this.getOptions()).withWorkDirectory(this.myWorkingDir);
    }

    private static List<String> getParameters(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/play/console/PlayConsoleRunner", "getParameters"));
        }
        LinkedList<String> params = new LinkedList<String>();
        for (String s : StringUtil.split((String)command, (String)" ")) {
            if ("play".equals(s.trim())) continue;
            params.add(s.trim());
        }
        return params;
    }

    static String getExePath(String playHome) {
        if (!playHome.endsWith(File.separator)) {
            playHome = playHome + File.separator;
        }
        return playHome + (SystemInfo.isWindows ? "play.bat" : "play");
    }

    protected String getOptions() {
        return "-Djline.WindowsTerminal.directConsole=false";
    }

    @Override
    protected String getToolWindowId() {
        return ToolWindowId.RUN;
    }
}

