/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.util.PathUtil;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JUnitExternalLibraryDescriptor
extends ExternalLibraryDescriptor {
    public static final ExternalLibraryDescriptor JUNIT3 = new JUnitExternalLibraryDescriptor("3"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            List<String> list = Collections.singletonList(JavaSdkUtil.getJunit3JarPath());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitExternalLibraryDescriptor$1", "getLibraryClassesRoots"));
            }
            return list;
        }
    };
    public static final ExternalLibraryDescriptor JUNIT4 = new JUnitExternalLibraryDescriptor("4"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            List list = JavaSdkUtil.getJUnit4JarPaths();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitExternalLibraryDescriptor$2", "getLibraryClassesRoots"));
            }
            return list;
        }
    };
    public static final ExternalLibraryDescriptor JUNIT5 = new JUnitExternalLibraryDescriptor("org.junit.jupiter", "junit-jupiter-api", "5"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            List<String> list = Arrays.asList(PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.junit.jupiter.api.Test")), PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.opentest4j.AssertionFailedError")));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitExternalLibraryDescriptor$3", "getLibraryClassesRoots"));
            }
            return list;
        }
    };
    private final String myVersion;

    private JUnitExternalLibraryDescriptor(String version) {
        this("junit", "junit", version);
    }

    private JUnitExternalLibraryDescriptor(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version + ".0", version + ".999");
        this.myVersion = version;
    }

    public String getPresentableName() {
        return "JUnit" + this.myVersion;
    }
}

