/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.ApplicableStreamProvider;
import com.intellij.cloudConfig.NetworkStatistics;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.cloudConfig.StreamProviderKt;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageBaseKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cloudconfig.CloudConfigClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigManager
implements ApplicationLoadListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cloudConfig.CloudConfigManager");
    private static final String LOCAL_DISABLED_PLUGINS_FILENAME = "local_disabled_plugins.txt";
    private static CloudConfigManager ourInstance;
    private File myIdeConfigPath;
    private File myConfigDir;
    private File myStatusFile;
    private File myVersionFile;
    private StatusInfo myStatusInfo;
    private CloudConfigClient myClient;
    private boolean myIOError;
    private FileIndex myIndex;
    private LocalChanges myLocalChanges;
    private final NetworkStatistics myNetworkStatistics = new NetworkStatistics();
    private FrameStateListener myFrameListener;
    private Runnable myDisablePluginsListener;
    private PluginStateListener myPluginListener;
    private static final Function2<Class, String, String> KEYMAP_CONVERTER;
    private static final String[] OS_NAMES;

    @NotNull
    public static CloudConfigManager getInstance() {
        CloudConfigManager cloudConfigManager = ourInstance;
        if (cloudConfigManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getInstance"));
        }
        return cloudConfigManager;
    }

    @NotNull
    public StatusInfo getStatusInfo() {
        if (this.myIOError) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_ERROR;
            if (statusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
            }
            return statusInfo;
        }
        if (this.myStatusInfo != StatusInfo.OFFLINE && this.myStatusInfo != StatusInfo.JBA_CONNECTED && CloudConfigManager.isStreamProviderEnabled()) {
            StatusInfo statusInfo = StatusInfo.OFFLINE;
            if (statusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
            }
            return statusInfo;
        }
        StatusInfo statusInfo = this.myStatusInfo;
        if (statusInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
        }
        return statusInfo;
    }

    public void beforeApplicationLoaded(@NotNull Application application, @NotNull String configPath) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/cloudConfig/CloudConfigManager", "beforeApplicationLoaded"));
        }
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/cloudConfig/CloudConfigManager", "beforeApplicationLoaded"));
        }
        ourInstance = this;
        if (!Boolean.getBoolean("use.jba.cloud.config") || CloudConfigManager.isStreamProviderEnabled()) {
            this.myStatusInfo = StatusInfo.OFFLINE;
            return;
        }
        this.myIdeConfigPath = new File(configPath);
        this.myConfigDir = new File(configPath, "jba_config");
        this.myStatusFile = new File(this.myConfigDir, "status.info");
        this.myVersionFile = new File(this.myConfigDir, "version");
        this.myLocalChanges = new LocalChanges();
        try {
            this.myStatusInfo = StatusInfo.valueOf(FileUtil.loadFile((File)this.myStatusFile));
            if (this.myStatusInfo == StatusInfo.DISABLED) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myClient = CloudConfigClientUtil.createClient();
        if (this.myClient == null) {
            this.myStatusInfo = StatusInfo.JBA_NOT_FOUND;
            return;
        }
        File autoConnect = new File(this.myConfigDir, ".auto_connect");
        if (autoConnect.exists()) {
            boolean remote = false;
            try {
                remote = "remote".equals(FileUtil.loadFile((File)autoConnect));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileUtil.delete((File)autoConnect);
            if (remote) {
                this.connectThisInstance(false);
            } else {
                this.connectFirstInstance(true);
            }
        } else if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
            this.myLocalChanges.load();
            this.updateConnection(true);
        } else {
            this.calculateInitStatus();
        }
        LOG.info("=== Start: " + (Object)((Object)this.myStatusInfo) + " ===");
    }

    public void recalculateInitStatus() {
        if (this.myStatusInfo == StatusInfo.DISABLED && this.myClient == null) {
            this.myClient = CloudConfigClientUtil.createClient();
            LOG.assertTrue(this.myClient != null);
        }
        this.calculateInitStatus();
        if (this.myStatusInfo != StatusInfo.DISABLED) {
            FileUtil.delete((File)this.myStatusFile);
        }
    }

    private void calculateInitStatus() {
        try {
            this.myStatusInfo = StringUtil.isEmpty((String)this.clientGetValue("version")) ? StatusInfo.JBA_NOT_CONNECTED : StatusInfo.JBA_THIS_NOT_CONNECTED;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    @Nullable
    public StatusInfo updateIO() {
        if (!this.checkIO()) {
            return null;
        }
        if (this.myStatusInfo == null) {
            this.calculateInitStatus();
        } else if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
            this.updateConnection(false);
        }
        return this.myStatusInfo;
    }

    private boolean checkIO() {
        try {
            this.clientGetValue("io");
            return true;
        }
        catch (IOException e) {
            CloudConfigManager.logDebug(e);
            return false;
        }
    }

    public void disable() {
        this.myStatusInfo = StatusInfo.DISABLED;
        this.myIOError = false;
        this.myClient = null;
        this.storeState();
    }

    public void disconnect(boolean removeData, boolean reload) {
        try {
            FileUtil.delete((File)this.myConfigDir);
            this.myIndex = null;
            this.myLocalChanges.clean();
            this.removeListeners();
            if (removeData) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("version", null);
                properties.put("files", null);
                properties.put("os", null);
                this.filesToNull(properties);
                this.clientPut(properties);
                this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            } else {
                this.myStatusInfo = StatusInfo.JBA_THIS_NOT_CONNECTED;
            }
            this.setStreamProvider(true, reload);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnection(boolean provider) {
        try {
            FileIndex remoteIndex;
            String remoteVersion;
            block15: {
                if (provider) {
                    this.myIndex = new FileIndex(this.readVersionList());
                }
                remoteVersion = this.clientGetValue("version");
                if (remoteVersion != null) break block15;
                this.disconnect(false, !provider);
                this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
                return;
            }
            try {
                remoteIndex = new FileIndex(remoteVersion);
            }
            catch (IOException e) {
                remoteIndex = this.myIndex;
                CloudConfigManager.logDebug(e);
            }
            if (this.myIndex.version.equals(remoteIndex.version)) {
                if (provider) {
                    this.setStreamProvider(false, false);
                }
                return;
            }
            if (this.myIndex.testNextIndexVersion(remoteIndex)) {
                remoteIndex.readIndex(this.clientGetList("files", "\n"));
                CloudConfigManager.getStateStorageManager().setStreamProvider((StreamProvider)new ApplicableStreamProvider(this.myConfigDir, this));
                this.updateFiles(remoteIndex, !provider);
                this.initListeners();
                return;
            }
            this.connectThisInstance(!provider);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myLocalChanges.apply();
        }
    }

    public void connectFirstInstance(boolean cleanup) {
        try {
            FileUtil.delete((File)this.myConfigDir);
            FileUtil.createDirectory((File)this.myConfigDir);
            ApplicationManager.getApplication().saveSettings();
            this.myLocalChanges.clean();
            this.myIndex = this.copyConfigs(KEYMAP_CONVERTER, LafManagerImpl.class, KeymapManagerImpl.class, EditorColorsManagerImpl.class);
            this.pushToServer(cleanup);
            this.setStreamProvider(false, false);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void initListeners() {
        if (this.myFrameListener == null) {
            this.myFrameListener = new FrameStateListener(){
                long time;

                public void onFrameDeactivated() {
                    this.time = System.currentTimeMillis();
                }

                public void onFrameActivated() {
                    if (CloudConfigManager.this.myStatusInfo == StatusInfo.JBA_CONNECTED && System.currentTimeMillis() - this.time > 3600000L) {
                        CloudConfigManager.this.updateConnection(false);
                    }
                }
            };
            FrameStateManager.getInstance().addListener(this.myFrameListener);
        }
        if (this.myDisablePluginsListener == null) {
            this.myDisablePluginsListener = () -> {
                try {
                    File localFile = new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME);
                    LinkedHashSet oldPlugins = new LinkedHashSet(FileUtil.loadLines((File)localFile));
                    File sourceFile = new File(this.myIdeConfigPath, "disabled_plugins.txt");
                    LinkedHashSet newPlugins = new LinkedHashSet(FileUtil.loadLines((File)sourceFile));
                    Iterator I = newPlugins.iterator();
                    while (I.hasNext()) {
                        if (!oldPlugins.remove(I.next())) continue;
                        I.remove();
                    }
                    if (oldPlugins.isEmpty() && newPlugins.isEmpty()) {
                        return;
                    }
                    FileUtil.copyContent((File)sourceFile, (File)localFile);
                    List<Pair<String, String>> plugins = this.loadPlugins("disabled_plugins.txt");
                    for (String deletedPluginId : oldPlugins) {
                        CloudConfigManager.removePlugin(plugins, deletedPluginId);
                    }
                    for (String newPluginId : newPlugins) {
                        CloudConfigManager.addPlugin(plugins, newPluginId);
                    }
                    this.savePlugins(plugins, "disabled_plugins.txt");
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            };
            PluginManagerCore.addDisablePluginListener((Runnable)this.myDisablePluginsListener);
        }
        if (this.myPluginListener == null) {
            this.myPluginListener = new PluginStateListener(){

                public void install(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager$2", "install"));
                    }
                    try {
                        if (descriptor.isBundled()) {
                            return;
                        }
                        String pluginId = descriptor.getPluginId().getIdString();
                        if (ContainerUtil.find((Iterable)CloudConfigManager.getRepositoryPlugins(), remote -> remote.getPluginId().getIdString().equals(pluginId)) == null) {
                            return;
                        }
                        List plugins = CloudConfigManager.this.loadPlugins("installed_plugins.txt");
                        CloudConfigManager.addPlugin(plugins, pluginId);
                        CloudConfigManager.this.savePlugins(plugins, "installed_plugins.txt");
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }

                public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager$2", "uninstall"));
                    }
                    try {
                        List plugins = CloudConfigManager.this.loadPlugins("installed_plugins.txt");
                        CloudConfigManager.removePlugin(plugins, descriptor.getPluginId().getIdString());
                        CloudConfigManager.this.savePlugins(plugins, "installed_plugins.txt");
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            };
            PluginInstaller.addStateListener((PluginStateListener)this.myPluginListener);
        }
    }

    @NotNull
    private List<Pair<String, String>> loadPlugins(String name) throws IOException {
        List lines = FileUtil.loadLines((File)new File(this.myConfigDir, name));
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        int size = lines.size();
        for (int i = 0; i < size; i += 2) {
            result.add((Pair<String, String>)Pair.create(lines.get(i), lines.get(i + 1)));
        }
        ArrayList<Pair<String, String>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "loadPlugins"));
        }
        return arrayList;
    }

    private void savePlugins(@NotNull List<Pair<String, String>> plugins, @NotNull String name) throws Exception {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        this.savePlugins(plugins, name, (ParameterizedRunnable<String>)((ParameterizedRunnable)content -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "lambda$savePlugins$2"));
            }
            this.editConfigFile(name, (String)content);
        }));
    }

    private void savePlugins(@NotNull List<Pair<String, String>> plugins, @NotNull String name, @NotNull ParameterizedRunnable<String> function) throws Exception {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        String content = StringUtil.join(plugins, p -> (String)p.first + "\n" + (String)p.second, (String)"\n");
        FileUtil.writeToFile((File)new File(this.myConfigDir, name), (String)content);
        function.run((Object)content);
    }

    private static void addPlugin(@NotNull List<Pair<String, String>> plugins, @NotNull String pluginId) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "addPlugin"));
        }
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "addPlugin"));
        }
        Pair result = (Pair)ContainerUtil.find(plugins, p -> {
            if (pluginId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "lambda$addPlugin$4"));
            }
            return ((String)p.first).equals(pluginId);
        });
        if (result == null) {
            plugins.add((Pair<String, String>)Pair.create((Object)pluginId, (Object)"1"));
        } else {
            plugins.set(plugins.indexOf(result), (Pair<String, String>)Pair.create((Object)result.first, (Object)CloudConfigManager.plusOne((String)result.second)));
        }
    }

    private static void removePlugin(@NotNull List<Pair<String, String>> plugins, @NotNull String pluginId) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "removePlugin"));
        }
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "removePlugin"));
        }
        Pair result = (Pair)ContainerUtil.find(plugins, p -> {
            if (pluginId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "lambda$removePlugin$5"));
            }
            return ((String)p.first).equals(pluginId);
        });
        LOG.assertTrue(result != null);
        if (((String)result.second).equals("1")) {
            plugins.remove(result);
        } else {
            plugins.set(plugins.indexOf(result), (Pair<String, String>)Pair.create((Object)result.first, (Object)CloudConfigManager.minusOne((String)result.second)));
        }
    }

    private void removeListeners() {
        if (this.myFrameListener != null) {
            FrameStateManager.getInstance().removeListener(this.myFrameListener);
            this.myFrameListener = null;
        }
        if (this.myDisablePluginsListener != null) {
            PluginManagerCore.removeDisablePluginListener((Runnable)this.myDisablePluginsListener);
            this.myDisablePluginsListener = null;
        }
        if (this.myPluginListener != null) {
            PluginInstaller.removeStateListener((PluginStateListener)this.myPluginListener);
            this.myPluginListener = null;
        }
    }

    public void connectThisInstance(boolean reload) {
        try {
            FileUtil.delete((File)this.myConfigDir);
            FileUtil.createDirectory((File)this.myConfigDir);
            this.myLocalChanges.clean();
            String[] values = this.clientGetValues("version", "files", "os");
            this.myIndex = new FileIndex(values[0], values[1]);
            List localNames = ContainerUtil.filter(this.myIndex.files.keySet(), CloudConfigManager::filterOsName);
            String[] files = this.clientGetValues((String[])ContainerUtil.map2Array((Collection)localNames, String.class, CloudConfigClientUtil::toServerName));
            int length = files.length;
            for (int i = 0; i < length; ++i) {
                FileUtil.writeToFile((File)new File(this.myConfigDir, (String)localNames.get(i)), (String)files[i]);
            }
            LOG.assertTrue(values[2] != null);
            List osNames = StringUtil.split((String)values[2], (String)"\n");
            String os = CloudConfigClientUtil.getOS();
            HashMap<String, String> properties = new HashMap<String, String>();
            if (!osNames.contains(os)) {
                FileIndex index = this.copyConfigs(KEYMAP_CONVERTER, KeymapManagerImpl.class);
                this.myIndex.files.putAll(index.files);
                for (String file : index.files.keySet()) {
                    String name = CloudConfigClientUtil.toServerName((String)file);
                    String content = FileUtil.loadFile((File)new File(this.myConfigDir, file));
                    properties.put(name, content);
                }
                osNames.add(os);
                properties.put("os", StringUtil.join((Collection)osNames, (String)"\n"));
            }
            FileUtil.copyContent((File)new File(this.myIdeConfigPath, "disabled_plugins.txt"), (File)new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME));
            ArrayList disabledPluginIds = new ArrayList();
            PluginManagerCore.loadDisabledPlugins((String)this.myIdeConfigPath.getAbsolutePath(), disabledPluginIds);
            this.appendPlugins(disabledPluginIds, "disabled_plugins.txt", properties, pluginId -> pluginId);
            this.appendPlugins(CloudConfigManager.getInstalledPlugins(), "installed_plugins.txt", properties, descriptor -> descriptor.getPluginId().getIdString());
            if (!properties.isEmpty()) {
                properties.put("version", this.myIndex.nextVersion());
                properties.put("files", this.myIndex.getFiles());
                this.clientPut(properties);
            }
            this.setConnected(this.myIndex.getVersions());
            this.setStreamProvider(false, reload);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private FileIndex copyConfigs(@NotNull Function2<Class, String, String> nameConverter, Class ... storageClasses) throws Exception {
        if (nameConverter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameConverter", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        if (storageClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageClasses", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        FileIndex index = new FileIndex();
        File optionsDir = new File(this.myIdeConfigPath, "options");
        for (Class storageClass : storageClasses) {
            File dir;
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            String name = StreamProviderKt.getFileConfig(spec);
            String outName = (String)nameConverter.invoke((Object)storageClass, (Object)name);
            this.addFile(index, new File(optionsDir, name), outName);
            String schemeDir = spec.additionalExportFile();
            if (schemeDir.length() <= 0 || !(dir = new File(this.myIdeConfigPath, schemeDir)).exists() || !dir.isDirectory()) continue;
            SchemeManagerImpl scheme = CloudConfigManager.findScheme(schemeDir);
            String schemeOutDir = (String)nameConverter.invoke((Object)storageClass, (Object)schemeDir);
            FileUtil.copyDir((File)dir, (File)new File(this.myConfigDir, schemeOutDir), childFile -> {
                String childName = childFile.getName();
                boolean canRead = scheme.canRead((CharSequence)childName);
                if (canRead) {
                    index.modifyFile(schemeOutDir + "/" + childName);
                }
                return canRead;
            });
        }
        this.addPlugins(index);
        FileIndex fileIndex = index;
        if (fileIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        return fileIndex;
    }

    private void addFile(@NotNull FileIndex index, @NotNull File file, @NotNull String name) throws IOException {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "addFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cloudConfig/CloudConfigManager", "addFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "addFile"));
        }
        if (file.exists() && file.isFile()) {
            index.modifyFile(name);
            FileUtil.copyContent((File)file, (File)new File(this.myConfigDir, name));
        }
    }

    private void addPlugins(FileIndex index) throws Exception {
        FileUtil.copyContent((File)new File(this.myIdeConfigPath, "disabled_plugins.txt"), (File)new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME));
        ArrayList disabledPlugins = new ArrayList();
        PluginManagerCore.loadDisabledPlugins((String)this.myIdeConfigPath.getAbsolutePath(), disabledPlugins);
        FileUtil.writeToFile((File)new File(this.myConfigDir, "disabled_plugins.txt"), (String)StringUtil.join(disabledPlugins, id -> id + "\n1", (String)"\n"));
        index.modifyFile("disabled_plugins.txt");
        FileUtil.writeToFile((File)new File(this.myConfigDir, "installed_plugins.txt"), (String)StringUtil.join(CloudConfigManager.getInstalledPlugins(), descriptor -> descriptor.getPluginId().getIdString() + "\n1", (String)"\n"));
        index.modifyFile("installed_plugins.txt");
    }

    private <T> void appendPlugins(@NotNull List<T> localPlugins, @NotNull String name, @NotNull Map<String, String> properties, @NotNull Function<T, String> converter) throws Exception {
        if (localPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPlugins", "com/intellij/cloudConfig/CloudConfigManager", "appendPlugins"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "appendPlugins"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/cloudConfig/CloudConfigManager", "appendPlugins"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/cloudConfig/CloudConfigManager", "appendPlugins"));
        }
        if (localPlugins.isEmpty()) {
            return;
        }
        List<Pair<String, String>> plugins = this.loadPlugins(name);
        for (T descriptor : localPlugins) {
            CloudConfigManager.addPlugin(plugins, (String)converter.fun(descriptor));
        }
        this.myIndex.modifyFile(name);
        this.savePlugins(plugins, name, (ParameterizedRunnable<String>)((ParameterizedRunnable)content -> {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/cloudConfig/CloudConfigManager", "lambda$appendPlugins$11"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "lambda$appendPlugins$11"));
            }
            properties.put(CloudConfigClientUtil.toServerName((String)name), (String)content);
        }));
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getInstalledPlugins() throws Exception {
        List<IdeaPluginDescriptor> plugins = new ArrayList();
        ContainerUtil.addAll(plugins, (Object[])PluginManagerCore.getPlugins());
        plugins.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        plugins = ContainerUtil.filter(plugins, descriptor -> {
            if (descriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor).isDeleted()) {
                return false;
            }
            return !descriptor.isBundled() && descriptor.isEnabled();
        });
        if (!plugins.isEmpty()) {
            List<IdeaPluginDescriptor> repositoryPlugins = CloudConfigManager.getRepositoryPlugins();
            plugins = ContainerUtil.filter(plugins, local -> {
                PluginId id = local.getPluginId();
                return ContainerUtil.find((Iterable)repositoryPlugins, remote -> remote.getPluginId().compareTo(id) == 0) != null;
            });
        }
        List<IdeaPluginDescriptor> list = plugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getInstalledPlugins"));
        }
        return list;
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getRepositoryPlugins() throws Exception {
        List list = (List)ApplicationManager.getApplication().executeOnPooledThread(() -> RepositoryHelper.loadPlugins(null)).get();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getRepositoryPlugins"));
        }
        return list;
    }

    @NotNull
    private static SchemeManagerImpl findScheme(final @NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/cloudConfig/CloudConfigManager", "findScheme"));
        }
        final Ref result = new Ref();
        ((SchemeManagerFactoryBase)SchemeManagerFactory.getInstance()).process((Function1)new Function1<SchemeManagerImpl<Scheme, ? extends Scheme>, Unit>(){

            public Unit invoke(SchemeManagerImpl<Scheme, ? extends Scheme> manager) {
                if (result.isNull() && fileSpec.equals(manager.getFileSpec())) {
                    result.set(manager);
                }
                return null;
            }
        });
        SchemeManagerImpl schemeManagerImpl = (SchemeManagerImpl)result.get();
        if (schemeManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "findScheme"));
        }
        return schemeManagerImpl;
    }

    private void pushToServer(boolean cleanup) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("version", this.myIndex.version);
        if (cleanup) {
            this.filesToNull(properties);
        }
        for (String file : this.myIndex.files.keySet()) {
            String name = CloudConfigClientUtil.toServerName((String)file);
            String content = FileUtil.loadFile((File)new File(this.myConfigDir, file));
            properties.put(name, content);
        }
        properties.put("files", this.myIndex.getFiles());
        properties.put("os", CloudConfigClientUtil.getOS());
        this.clientPut(properties);
        this.setConnected(this.myIndex.getVersions());
    }

    private void setConnected(String version) throws IOException {
        this.writeVersion(version);
        this.myStatusInfo = StatusInfo.JBA_CONNECTED;
        this.storeStateIO();
    }

    public void editConfigFile(@NotNull String fileName, @Nullable String content) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/cloudConfig/CloudConfigManager", "editConfigFile"));
        }
        boolean delete = content == null;
        this.updateConnection(false);
        if (this.myIOError) {
            this.myLocalChanges.addFile(fileName, delete);
            return;
        }
        LOG.info("=== " + (delete ? "Delete" : "Edit") + " File: " + fileName + " ===");
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (delete) {
                if (this.myIndex.files.remove(fileName) == null) {
                    return;
                }
            } else {
                this.myIndex.modifyFile(fileName);
            }
            properties.put(CloudConfigClientUtil.toServerName((String)fileName), content);
            properties.put("version", this.myIndex.nextVersion());
            properties.put("files", this.myIndex.getFiles());
            this.clientPut(properties);
            this.writeVersion(this.myIndex.getVersions());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void editConfigFiles(@NotNull Set<String> editedFiles, @NotNull Set<String> deletedFiles) throws Exception {
        if (editedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedFiles", "com/intellij/cloudConfig/CloudConfigManager", "editConfigFiles"));
        }
        if (deletedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deletedFiles", "com/intellij/cloudConfig/CloudConfigManager", "editConfigFiles"));
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String fileSpec : editedFiles) {
            File file = new File(this.myConfigDir, fileSpec);
            if (!file.exists()) continue;
            this.myIndex.modifyFile(fileSpec);
            properties.put(CloudConfigClientUtil.toServerName((String)fileSpec), FileUtil.loadFile((File)file));
            LOG.info("=== LC->Server.Edit File: " + fileSpec + " ===");
        }
        for (String fileSpec : deletedFiles) {
            if (this.myIndex.files.remove(fileSpec) == null) continue;
            properties.put(CloudConfigClientUtil.toServerName((String)fileSpec), null);
            LOG.info("=== LC->Server.Delete File: " + fileSpec + " ===");
        }
        properties.put("version", this.myIndex.nextVersion());
        properties.put("files", this.myIndex.getFiles());
        this.clientPut(properties);
        this.writeVersion(this.myIndex.getVersions());
    }

    @NotNull
    private static String plusOne(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigManager", "plusOne"));
        }
        String string = Integer.toString(Integer.parseInt(value) + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "plusOne"));
        }
        return string;
    }

    @NotNull
    private static String minusOne(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigManager", "minusOne"));
        }
        String string = Integer.toString(Integer.parseInt(value) - 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "minusOne"));
        }
        return string;
    }

    private void storeState() {
        try {
            this.storeStateIO();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void storeStateIO() throws IOException {
        FileUtil.writeToFile((File)this.myStatusFile, (String)this.myStatusInfo.name());
    }

    @NotNull
    private List<String> readVersionList() throws IOException {
        List list = StringUtil.split((String)FileUtil.loadFile((File)this.myVersionFile), (String)"\n");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "readVersionList"));
        }
        return list;
    }

    private void writeVersion(String version) throws IOException {
        FileUtil.writeToFile((File)this.myVersionFile, (String)version);
    }

    private void setStreamProvider(boolean noProvider, boolean reload) {
        ApplicableStreamProvider streamProvider = noProvider ? null : new ApplicableStreamProvider(this.myConfigDir, this);
        CloudConfigManager.getStateStorageManager().setStreamProvider((StreamProvider)streamProvider);
        if (!noProvider) {
            this.initListeners();
        }
        if (reload) {
            File optionsDir = noProvider ? new File(this.myIdeConfigPath, "options") : this.myConfigDir;
            CloudConfigManager.reloadComponents(optionsDir, !noProvider, null, LafManagerImpl.class, KeymapManagerImpl.class, EditorColorsManagerImpl.class);
        }
    }

    private void updateFiles(@NotNull FileIndex remoteIndex, boolean reload) throws Exception {
        if (remoteIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteIndex", "com/intellij/cloudConfig/CloudConfigManager", "updateFiles"));
        }
        LOG.info("=== Update Files ===");
        HashSet<String> changedFiles = new HashSet<String>();
        HashMap<String, String> remoteFiles = new HashMap<String, String>(remoteIndex.files);
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> serverNames = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.myIndex.files.entrySet()) {
            String fileName = entry.getKey();
            String remoteVersion = (String)remoteFiles.remove(fileName);
            if (remoteVersion != null && remoteVersion.equals(entry.getValue())) continue;
            this.updateFile(changedFiles, fileName, remoteVersion == null, files, serverNames);
        }
        for (String fileName : remoteFiles.keySet()) {
            this.updateFile(changedFiles, fileName, false, files, serverNames);
        }
        String[] content = this.clientGetValues(ArrayUtil.toStringArray(serverNames));
        int length = content.length;
        for (int i = 0; i < length; ++i) {
            FileUtil.writeToFile((File)((File)files.get(i)), (String)content[i]);
        }
        if (reload && !changedFiles.isEmpty()) {
            CloudConfigManager.reloadComponents(this.myConfigDir, true, changedFiles, LafManagerImpl.class, KeymapManagerImpl.class, EditorColorsManagerImpl.class);
        }
        this.writeVersion(remoteIndex.getVersions());
        this.myIndex = remoteIndex;
    }

    private static boolean filterOsName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/cloudConfig/CloudConfigManager", "filterOsName"));
        }
        if (!fileName.startsWith(CloudConfigClientUtil.getOS() + ".")) {
            for (String name : OS_NAMES) {
                if (!fileName.startsWith(name + ".")) continue;
                return false;
            }
        }
        return true;
    }

    private void updateFile(Set<String> changedFiles, String fileName, boolean delete, @NotNull List<File> files, @NotNull List<String> serverNames) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "updateFile"));
        }
        if (serverNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverNames", "com/intellij/cloudConfig/CloudConfigManager", "updateFile"));
        }
        File file = new File(this.myConfigDir, fileName);
        if (delete) {
            FileUtil.delete((File)file);
            LOG.info("=== Update File(Delete): " + fileName + " ===");
        } else if (CloudConfigManager.filterOsName(fileName)) {
            files.add(file);
            serverNames.add(CloudConfigClientUtil.toServerName((String)fileName));
            LOG.info("=== Update File(Edit): " + fileName + " ===");
        } else {
            LOG.info("=== Update File(Skip): " + fileName + " ===");
            return;
        }
        changedFiles.add(StringUtil.defaultIfEmpty((String)StringUtil.substringBefore((String)fileName, (String)"/"), (String)fileName));
    }

    private static void reloadComponents(@NotNull File optionsDir, boolean streamProvider, @Nullable Set<String> changedFiles, Class ... storageClasses) {
        if (optionsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsDir", "com/intellij/cloudConfig/CloudConfigManager", "reloadComponents"));
        }
        if (storageClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageClasses", "com/intellij/cloudConfig/CloudConfigManager", "reloadComponents"));
        }
        final LinkedHashSet<String> componentNames = new LinkedHashSet<String>();
        final HashSet<StateStorage> changedStorages = new HashSet<StateStorage>();
        ArrayList<SchemeManagerImpl> schemes = new ArrayList<SchemeManagerImpl>();
        StateStorageManagerImpl storageManager = CloudConfigManager.getStateStorageManager();
        for (Class storageClass : storageClasses) {
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            boolean addComponent = false;
            String schemeDir = spec.additionalExportFile();
            if (schemeDir.length() > 0 && (changedFiles == null || changedFiles.contains(schemeDir))) {
                schemes.add(CloudConfigManager.findScheme(schemeDir));
                addComponent = true;
            }
            String name = StreamProviderKt.getFileConfig(spec);
            boolean exists = new File(optionsDir, name).exists();
            StateStorage storage = storageManager.findCachedFileStorage(name);
            LOG.assertTrue(storage instanceof XmlElementStorage);
            changedStorages.add(storage);
            ((XmlElementStorage)storage).updatedFrom(componentNames, !exists, streamProvider);
            if (!addComponent && changedFiles != null && !changedFiles.contains(name)) continue;
            componentNames.add(spec.name());
        }
        for (SchemeManagerImpl scheme : schemes) {
            scheme.reload();
        }
        Application application = ApplicationManager.getApplication();
        final ComponentStoreImpl store = (ComponentStoreImpl)ServiceKt.getStateStore((ComponentManager)application);
        final Collection notReloadableComponents = store.getNotReloadableComponents(componentNames);
        LOG.assertTrue(notReloadableComponents.isEmpty());
        StateStorageBaseKt.runBatchUpdate((MessageBus)application.getMessageBus(), (Function0)new Function0<Object>(){

            public Object invoke() {
                store.reinitComponents(componentNames, changedStorages, notReloadableComponents);
                return null;
            }
        });
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        LOG.info("=== Reload components: " + componentNames + " ===");
    }

    private static boolean isStreamProviderEnabled() {
        StreamProvider provider = CloudConfigManager.getStateStorageManager().getStreamProvider();
        return provider != null && provider.getEnabled();
    }

    @NotNull
    private static StateStorageManagerImpl getStateStorageManager() {
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
        if (stateStorageManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStateStorageManager"));
        }
        return stateStorageManagerImpl;
    }

    private void filesToNull(@NotNull Map<String, String> properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/cloudConfig/CloudConfigManager", "filesToNull"));
        }
        List<String> files = this.clientGetList("files", "\n");
        int size = files.size();
        for (int i = 0; i < size; i += 2) {
            properties.put(CloudConfigClientUtil.toServerName((String)files.get(i)), null);
        }
    }

    @NotNull
    private Map<String, String> clientGet(String ... properties) throws IOException {
        Map map;
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/cloudConfig/CloudConfigManager", "clientGet"));
        }
        try {
            Map result = this.myClient.get(CloudConfigClientUtil.getName(), properties);
            this.myNetworkStatistics.addBytes(result);
            this.myIOError = false;
            Map map2 = result;
            map = map2;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        finally {
            this.myNetworkStatistics.save();
        }
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "clientGet"));
        }
        return map;
    }

    @NotNull
    private String[] clientGetValues(String ... properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/cloudConfig/CloudConfigManager", "clientGetValues"));
        }
        Map<String, String> keyValue = this.clientGet(properties);
        String[] values = new String[properties.length];
        int length = properties.length;
        for (int i = 0; i < length; ++i) {
            values[i] = keyValue.get(properties[i]);
        }
        if (values == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "clientGetValues"));
        }
        return values;
    }

    @NotNull
    private List<String> clientGetList(@NotNull String property, @NotNull String separator) throws IOException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/cloudConfig/CloudConfigManager", "clientGetList"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/cloudConfig/CloudConfigManager", "clientGetList"));
        }
        String value = this.clientGetValue(property);
        List list = value == null ? Collections.emptyList() : StringUtil.split((String)value, (String)separator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "clientGetList"));
        }
        return list;
    }

    @Nullable
    private String clientGetValue(@NotNull String property) throws IOException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/cloudConfig/CloudConfigManager", "clientGetValue"));
        }
        return this.clientGet(property).get(property);
    }

    private void clientPut(@NotNull Map<String, String> properties) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/cloudConfig/CloudConfigManager", "clientPut"));
        }
        try {
            this.myNetworkStatistics.addBytes(properties);
            this.myClient.put(CloudConfigClientUtil.getName(), properties);
            this.myIOError = false;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        finally {
            this.myNetworkStatistics.save();
        }
    }

    private static void logDebug(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/CloudConfigManager", "logDebug"));
        }
        LOG.debug((Throwable)e);
    }

    static /* synthetic */ File access$1000(CloudConfigManager x0) {
        return x0.myConfigDir;
    }

    static {
        KEYMAP_CONVERTER = (storageClass, name) -> {
            if (storageClass == KeymapManagerImpl.class) {
                return CloudConfigClientUtil.getOS() + "." + name;
            }
            return name;
        };
        OS_NAMES = new String[]{"mac", "win", "linux", "freebsd", "unix", "unknown"};
    }

    private class LocalChanges {
        private final Set<String> myEditedFiles = new LinkedHashSet<String>();
        private final Set<String> myDeletedFiles = new LinkedHashSet<String>();
        private final File myFile = new File(CloudConfigManager.access$1000(CloudConfigManager.this), "local.changes");

        private LocalChanges() {
        }

        public void load() {
            try {
                if (this.myFile.exists()) {
                    Set<String> lines = this.myEditedFiles;
                    for (String line : FileUtil.loadLines((File)this.myFile)) {
                        if (line.isEmpty()) {
                            lines = this.myDeletedFiles;
                            continue;
                        }
                        lines.add(line);
                    }
                    LOG.info("=== Local Changes: " + this.myEditedFiles + " : " + this.myDeletedFiles + " ===");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        public void addFile(String file, boolean delete) {
            LOG.info("=== LC." + (delete ? "Delete" : "Edit") + " File: " + file + " ===");
            if (delete) {
                if (((CloudConfigManager)CloudConfigManager.this).myIndex.files.containsKey(file)) {
                    this.myDeletedFiles.add(file);
                } else {
                    this.myDeletedFiles.remove(file);
                }
                this.myEditedFiles.remove(file);
            } else {
                this.myEditedFiles.add(file);
                this.myDeletedFiles.remove(file);
            }
            if (this.isEmpty()) {
                FileUtil.delete((File)this.myFile);
            } else {
                this.doSave();
            }
        }

        private boolean isEmpty() {
            return this.myEditedFiles.isEmpty() && this.myDeletedFiles.isEmpty();
        }

        public void save() {
            if (!this.isEmpty()) {
                this.doSave();
            }
        }

        private void doSave() {
            try {
                FileUtil.writeToFile((File)this.myFile, (String)(StringUtil.join(this.myEditedFiles, (String)"\n") + (this.myEditedFiles.isEmpty() ? "" : "\n") + "\n" + StringUtil.join(this.myDeletedFiles, (String)"\n")));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        public void apply() {
            if (CloudConfigManager.this.myIOError || this.isEmpty()) {
                return;
            }
            try {
                CloudConfigManager.this.editConfigFiles(this.myEditedFiles, this.myDeletedFiles);
                this.clean();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public void clean() {
            this.myEditedFiles.clear();
            this.myDeletedFiles.clear();
            FileUtil.delete((File)this.myFile);
        }
    }

    private static class FileIndex {
        public String version;
        private String myBaseVersion;
        private String myIndexVersion;
        public final Map<String, String> files;

        public FileIndex() {
            this.files = new LinkedHashMap<String, String>();
            String time = Long.toString(System.currentTimeMillis());
            this.myBaseVersion = time.substring(0, 4) + time.substring(time.length() - 4);
            this.myIndexVersion = "0";
            this.updateVersion();
        }

        public FileIndex(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "<init>"));
            }
            this.files = new LinkedHashMap<String, String>();
            this.readVersion(version);
        }

        public FileIndex(@NotNull String version, @NotNull String values) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "<init>"));
            }
            this.files = new LinkedHashMap<String, String>();
            this.readVersion(version);
            this.readIndex(StringUtil.split((String)values, (String)"\n"));
        }

        public FileIndex(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "<init>"));
            }
            this.files = new LinkedHashMap<String, String>();
            LOG.assertTrue(!values.isEmpty());
            this.readVersion(values.remove(0));
            this.readIndex(values);
        }

        private void readVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "readVersion"));
            }
            this.version = version;
            this.myBaseVersion = StringUtil.substringBefore((String)version, (String)":");
            LOG.assertTrue(this.myBaseVersion != null);
            this.myIndexVersion = StringUtil.substringAfter((String)version, (String)":");
            LOG.assertTrue(this.myIndexVersion != null);
        }

        public void readIndex(@NotNull List<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "readIndex"));
            }
            int size = values.size();
            for (int i = 0; i < size; i += 2) {
                this.files.put(values.get(i), values.get(i + 1));
            }
        }

        public void modifyFile(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "modifyFile"));
            }
            String fileVersion = this.files.get(name);
            if (fileVersion == null) {
                this.files.put(name, this.myIndexVersion);
            } else {
                this.files.put(name, CloudConfigManager.plusOne(fileVersion));
            }
        }

        private void updateVersion() {
            this.version = this.myBaseVersion + ":" + this.myIndexVersion;
        }

        @NotNull
        public String nextVersion() {
            this.myIndexVersion = CloudConfigManager.plusOne(this.myIndexVersion);
            this.updateVersion();
            String string = this.version;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "nextVersion"));
            }
            return string;
        }

        public boolean testNextIndexVersion(@NotNull FileIndex index) {
            if (index == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "testNextIndexVersion"));
            }
            return this.myBaseVersion.equals(index.myBaseVersion) && !this.myIndexVersion.equals(index.myIndexVersion);
        }

        @NotNull
        public String getFiles() {
            StringBuilder files = new StringBuilder();
            for (Map.Entry<String, String> entry : this.files.entrySet()) {
                files.append(entry.getKey()).append("\n").append(entry.getValue()).append("\n");
            }
            String string = files.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "getFiles"));
            }
            return string;
        }

        @NotNull
        public String getVersions() {
            String string = this.version + "\n" + this.getFiles();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager$FileIndex", "getVersions"));
            }
            return string;
        }
    }
}

