/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusInfoDialog
extends DialogWrapper {
    private final StatusInfo myStatus;
    private Action myDisableAction;
    private JRadioButton myUseShared;

    public StatusInfoDialog(@Nullable Project project, @NotNull StatusInfo status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/cloudConfig/StatusInfoDialog", "<init>"));
        }
        super(project);
        if (status != StatusInfo.JBA_CONNECTED) {
            this.myDisableAction = new AbstractAction("Don't Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StatusInfoDialog.this.close(1);
                    CloudConfigManager.getInstance().disable();
                }
            };
        }
        this.myStatus = status;
        this.setTitle("JBA Cloud Config");
        this.setResizable(false);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(550, 100));
        if (this.myStatus == StatusInfo.JBA_CONNECTED) {
            panel.add((Component)new JLabel("<html><body>Your <b>" + JetprofileSource.getSharedLogin() + "</b> JetBrains account<br/>used for shared <i>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</i> config (<b>Laf</b>, <b>Keymap</b> and <b>Color Schemes</b>)</html></body>"), "North");
            JButton disconnect = new JButton("Disconnect");
            disconnect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Messages.showYesNoDialog((String)"Disconnect this instance?", (String)"JBA Cloud Config", (String)"Yes", (String)"No", null, (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption(){

                        public boolean isToBeShown() {
                            return true;
                        }

                        public void setToBeShown(boolean toBeShown, int exitCode) {
                            if (exitCode == 0) {
                                StatusInfoDialog.this.close(1);
                                CloudConfigManager.getInstance().disconnect(!toBeShown, true);
                            }
                        }

                        public boolean canBeHidden() {
                            return true;
                        }

                        public boolean shouldSaveOptionsOnCancel() {
                            return false;
                        }

                        @NotNull
                        public String getDoNotShowMessage() {
                            if ("Remove data from cloud" == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog$2$1", "getDoNotShowMessage"));
                            }
                            return "Remove data from cloud";
                        }
                    });
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(disconnect);
            panel.add((Component)buttonPanel, "West");
            this.setOKButtonText("Done");
        } else if (this.myStatus == StatusInfo.JBA_NOT_CONNECTED) {
            panel.add((Component)new JLabel("<html><body>Share <i>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</i> config (<b>Laf</b>, <b>Keymap</b> and <b>Color Schemes</b>)<br/>to your <b>" + JetprofileSource.getSharedLogin() + "</b> JetBrains account?</body></html>"), "North");
        } else {
            assert (this.myStatus == StatusInfo.JBA_THIS_NOT_CONNECTED);
            panel.add((Component)new JLabel("<html><body>Your <b>" + JetprofileSource.getSharedLogin() + "</b> JetBrains account<br/>contains <i>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</i> config (<b>Laf</b>, <b>Keymap</b> and <b>Color Schemes</b>)<br/>Would your like:</html></body>"), "North");
            this.myUseShared = new JRadioButton("Replace local config and use shared");
            JRadioButton useLocal = new JRadioButton("Use local config and shared it");
            JPanel buttonPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            buttonPanel.add(this.myUseShared);
            buttonPanel.add(useLocal);
            ButtonGroup group = new ButtonGroup();
            group.add(this.myUseShared);
            group.add(useLocal);
            this.myUseShared.setSelected(true);
            panel.add((Component)buttonPanel, "Center");
        }
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myStatus == StatusInfo.JBA_CONNECTED) {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
            }
            return actionArray;
        }
        if (this.myDisableAction != null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{this.myDisableAction, this.getCancelAction(), this.getOKAction()};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.myDisableAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
        }
        return actionArray;
    }

    public void showAndHandleResult() {
        if (!this.showAndGet()) {
            return;
        }
        CloudConfigManager manager = CloudConfigManager.getInstance();
        if (this.myStatus == StatusInfo.JBA_NOT_CONNECTED) {
            manager.connectFirstInstance(false);
        } else if (this.myStatus == StatusInfo.JBA_THIS_NOT_CONNECTED) {
            if (this.myUseShared.isSelected()) {
                manager.connectThisInstance(true);
            } else {
                manager.connectFirstInstance(true);
            }
        }
    }
}

