/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.DispatchThreadProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.make.FormSourceCodeGenerator;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public final class GuiDesignerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.GuiDesignerConfigurable");
    private final Project myProject;
    private MyGeneralUI myGeneralUI;

    public GuiDesignerConfigurable(Project project) {
        this.myProject = project;
    }

    public String getDisplayName() {
        return UIDesignerBundle.message("title.gui.designer", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        if ("project.propGUI" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/GuiDesignerConfigurable", "getHelpTopic"));
        }
        return "project.propGUI";
    }

    public JComponent createComponent() {
        if (this.myGeneralUI == null) {
            this.myGeneralUI = new MyGeneralUI();
        }
        return this.myGeneralUI.myPanel;
    }

    public boolean isModified() {
        GuiDesignerConfiguration configuration = GuiDesignerConfiguration.getInstance(this.myProject);
        if (this.myGeneralUI == null) {
            return false;
        }
        if (this.myGeneralUI.myChkCopyFormsRuntime.isSelected() != configuration.COPY_FORMS_RUNTIME_TO_OUTPUT) {
            return true;
        }
        if (!Comparing.equal((Object)configuration.DEFAULT_LAYOUT_MANAGER, (Object)this.myGeneralUI.myLayoutManagerCombo.getSelectedItem())) {
            return true;
        }
        if (!Comparing.equal((Object)configuration.DEFAULT_FIELD_ACCESSIBILITY, (Object)this.myGeneralUI.myDefaultFieldAccessibilityCombo.getSelectedItem())) {
            return true;
        }
        if (configuration.INSTRUMENT_CLASSES != this.myGeneralUI.myRbInstrumentClasses.isSelected()) {
            return true;
        }
        return configuration.RESIZE_HEADERS != this.myGeneralUI.myResizeHeaders.isSelected();
    }

    public void apply() {
        GuiDesignerConfiguration configuration = GuiDesignerConfiguration.getInstance(this.myProject);
        configuration.COPY_FORMS_RUNTIME_TO_OUTPUT = this.myGeneralUI.myChkCopyFormsRuntime.isSelected();
        configuration.DEFAULT_LAYOUT_MANAGER = (String)this.myGeneralUI.myLayoutManagerCombo.getSelectedItem();
        configuration.INSTRUMENT_CLASSES = this.myGeneralUI.myRbInstrumentClasses.isSelected();
        configuration.DEFAULT_FIELD_ACCESSIBILITY = (String)this.myGeneralUI.myDefaultFieldAccessibilityCombo.getSelectedItem();
        configuration.RESIZE_HEADERS = this.myGeneralUI.myResizeHeaders.isSelected();
        if (configuration.INSTRUMENT_CLASSES && !this.myProject.isDefault()) {
            DispatchThreadProgressWindow progressWindow = new DispatchThreadProgressWindow(false, this.myProject);
            progressWindow.setRunnable((Runnable)new MyApplyRunnable(progressWindow));
            progressWindow.setTitle(UIDesignerBundle.message("title.converting.project", new Object[0]));
            progressWindow.start();
        }
    }

    public void reset() {
        GuiDesignerConfiguration configuration = GuiDesignerConfiguration.getInstance(this.myProject);
        if (configuration.INSTRUMENT_CLASSES) {
            this.myGeneralUI.myRbInstrumentClasses.setSelected(true);
        } else {
            this.myGeneralUI.myRbInstrumentSources.setSelected(true);
        }
        this.myGeneralUI.myChkCopyFormsRuntime.setSelected(configuration.COPY_FORMS_RUNTIME_TO_OUTPUT);
        this.myGeneralUI.myLayoutManagerCombo.setModel(new DefaultComboBoxModel<String>(LayoutManagerRegistry.getNonDeprecatedLayoutManagerNames()));
        this.myGeneralUI.myLayoutManagerCombo.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                this.setText(LayoutManagerRegistry.getLayoutManagerDisplayName(value));
            }
        });
        this.myGeneralUI.myLayoutManagerCombo.setSelectedItem(configuration.DEFAULT_LAYOUT_MANAGER);
        this.myGeneralUI.myDefaultFieldAccessibilityCombo.setSelectedItem(configuration.DEFAULT_FIELD_ACCESSIBILITY);
        this.myGeneralUI.myResizeHeaders.setSelected(configuration.RESIZE_HEADERS);
    }

    public void disposeUIResources() {
        this.myGeneralUI = null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/GuiDesignerConfigurable", "getId"));
        }
        return string;
    }

    private final class MyApplyRunnable
    implements Runnable {
        private final DispatchThreadProgressWindow myProgressWindow;

        public MyApplyRunnable(DispatchThreadProgressWindow progressWindow) {
            this.myProgressWindow = progressWindow;
        }

        private void vanishGeneratedSources() {
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)GuiDesignerConfigurable.this.myProject);
            PsiMethod[] methods = cache.getMethodsByName("$$$setupUI$$$", GlobalSearchScope.projectScope((Project)GuiDesignerConfigurable.this.myProject));
            CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])methods);
            for (int i = 0; i < methods.length; ++i) {
                PsiMethod method = methods[i];
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) continue;
                try {
                    PsiFile psiFile = aClass.getContainingFile();
                    LOG.assertTrue(psiFile != null);
                    VirtualFile vFile = psiFile.getVirtualFile();
                    LOG.assertTrue(vFile != null);
                    this.myProgressWindow.setText(UIDesignerBundle.message("progress.converting", vFile.getPresentableUrl()));
                    this.myProgressWindow.setFraction((double)i / (double)methods.length);
                    if (!vFile.isWritable()) continue;
                    FormSourceCodeGenerator.cleanup(aClass);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private void applyImpl() {
            CommandProcessor.getInstance().executeCommand(GuiDesignerConfigurable.this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                PsiDocumentManager.getInstance((Project)GuiDesignerConfigurable.this.myProject).commitAllDocuments();
                this.vanishGeneratedSources();
            }), "", null);
        }

        @Override
        public void run() {
            ProgressManager.getInstance().runProcess(() -> this.applyImpl(), (ProgressIndicator)this.myProgressWindow);
        }
    }

    private static final class MyGeneralUI {
        public JPanel myPanel;
        public JRadioButton myRbInstrumentClasses;
        public JRadioButton myRbInstrumentSources;
        public JCheckBox myChkCopyFormsRuntime;
        private JComboBox myLayoutManagerCombo;
        private JComboBox myDefaultFieldAccessibilityCombo;
        private JCheckBox myResizeHeaders;

        private MyGeneralUI() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JComboBox jComboBox;
            JComboBox jComboBox2;
            JCheckBox jCheckBox2;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 4, 0), -1, 0, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myRbInstrumentSources = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("radio.generate.into.java"));
            jRadioButton2.setMargin(new Insets(2, 0, 2, 2));
            jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myRbInstrumentClasses = jRadioButton = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("radio.generate.into.class"));
            jRadioButton.setMargin(new Insets(2, 0, 2, 2));
            jPanel2.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("label.generate.gui.into"));
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myChkCopyFormsRuntime = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("chk.copy.form.runtime"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("default.layout.manager"));
            jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("default.field.accessibility"));
            jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLayoutManagerCombo = jComboBox2 = new JComboBox();
            jPanel.add(jComboBox2, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myDefaultFieldAccessibilityCombo = jComboBox = new JComboBox();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            defaultComboBoxModel.addElement("private");
            defaultComboBoxModel.addElement("package-private");
            defaultComboBoxModel.addElement("protected");
            defaultComboBoxModel.addElement("public");
            jComboBox.setModel(defaultComboBoxModel);
            jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myResizeHeaders = jCheckBox = new JCheckBox();
            jCheckBox.setText("Resize column and row headers with mouse");
            jCheckBox.setMnemonic('R');
            jCheckBox.setDisplayedMnemonicIndex(0);
            jCheckBox.setMargin(new Insets(10, 0, 2, 2));
            jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            jLabel2.setLabelFor(jComboBox2);
            jLabel3.setLabelFor(jComboBox);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

