/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSAddBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";
    @NonNls
    private static final String ARROW_FUNCTION_KEYWORD = "arrow function";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        AddBracesPredicate addBracesPredicate = new AddBracesPredicate();
        if (addBracesPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "getElementPredicate"));
        }
        return addBracesPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            keyword = ARROW_FUNCTION_KEYWORD;
        } else if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = ifStatement.getElse();
            keyword = JSAddBracesIntention.quote(element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD);
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = JSAddBracesIntention.quote(firstChild.getText());
        }
        return this.getText(keyword);
    }

    private static String quote(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "quote"));
        }
        return '\'' + s + '\'';
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "processIntention"));
        }
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            boolean bracesAroundParameters = true;
            Iterator iterator = PsiTreeUtil.childIterator((PsiElement)element, PsiElement.class);
            ArrayList<PsiElement> comments = new ArrayList<PsiElement>();
            boolean arrowMet = false;
            while (iterator.hasNext()) {
                PsiElement next = (PsiElement)iterator.next();
                if (next instanceof JSParameterList) {
                    bracesAroundParameters = next.getNode().findChildByType(JSTokenTypes.LPAR) != null;
                    continue;
                }
                if (!arrowMet && next.getNode().getElementType() == JSTokenTypes.EQGT) {
                    arrowMet = true;
                    continue;
                }
                if (next instanceof JSExpression) {
                    String text = (bracesAroundParameters ? "() => {return b" : "a => {return v") + ";}";
                    JSFunctionExpression newFunction = (JSFunctionExpression)JSChangeUtil.createExpressionFromText((Project)element.getProject(), (String)text, (JSLanguageDialect)DialectDetector.languageDialectOfElement((PsiElement)element)).getPsi(JSFunctionExpression.class);
                    JSFunctionsHelper.moveParameters((JSFunction)((JSFunctionExpression)element), (JSFunction)newFunction);
                    JSReturnStatement returnStatement = (JSReturnStatement)PsiTreeUtil.findChildOfType((PsiElement)newFunction, JSReturnStatement.class);
                    if (!comments.isEmpty()) {
                        JSChangeUtil.addWs((ASTNode)returnStatement.getParent().getNode(), (ASTNode)returnStatement.getNode(), (String)"\n");
                        JSChangeUtil.addComments(comments, (PsiElement)returnStatement);
                    }
                    assert (returnStatement != null);
                    returnStatement.getExpression().replace(next);
                    PsiElement replaced = element.replace((PsiElement)newFunction);
                    CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)element.getProject());
                    PsiElement formatted = codeStyleManager.reformat(replaced);
                    codeStyleManager.reformatNewlyAddedElement(formatted.getNode().getTreeParent(), formatted.getNode());
                    return;
                }
                if (!arrowMet || !JSChangeUtil.isStatementOrComment((PsiElement)next) && !(next instanceof PsiWhiteSpace)) continue;
                comments.add(next);
            }
        }
        if (!(element instanceof JSStatement)) {
            return;
        }
        JSStatement statement = (JSStatement)element;
        JSElement parent = (JSElement)element.getParent();
        String text = element.getText();
        String newText = parent.getLastChild() instanceof PsiComment ? '{' + text + "\n}" : '{' + text + '}';
        JSAddBracesIntention.replaceAndReformat(statement, newText);
    }

    private static void replaceAndReformat(final @NotNull JSStatement statement, final @NotNull String text) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "replaceAndReformat"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "replaceAndReformat"));
        }
        final Ref newStatement = Ref.create();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)statement.getProject());
        codeStyleManager.performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                newStatement.set((Object)JSElementFactory.replaceStatement((JSStatement)statement, (String)text));
            }
        });
        PsiElement formatted = codeStyleManager.reformat((PsiElement)newStatement.get());
        codeStyleManager.reformatNewlyAddedElement(formatted.getNode().getTreeParent(), formatted.getNode());
    }

    private static boolean isShorthandArrowFunction(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "isShorthandArrowFunction"));
        }
        return element instanceof JSFunctionExpression && JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunction)element)) != null && PsiTreeUtil.getChildOfType((PsiElement)element, JSBlockStatement.class) == null;
    }

    private static class AddBracesPredicate
    implements JSElementPredicate {
        private AddBracesPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention$AddBracesPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSStatement)) {
                return JSAddBracesIntention.isShorthandArrowFunction(element);
            }
            if (element instanceof JSBlockStatement) {
                return false;
            }
            PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof JSElement)) {
                return false;
            }
            JSElement parent = (JSElement)parentElement;
            if (parent instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)parent;
                return !(element instanceof JSIfStatement) || !element.equals(ifStatement.getElse());
            }
            if (parent instanceof JSForStatement || parent instanceof JSForInStatement) {
                return element.equals(((JSLoopStatement)parent).getBody());
            }
            return parent instanceof JSWhileStatement || parent instanceof JSDoWhileStatement;
        }
    }
}

