/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.initialization.FlowJsAnnotationPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSCorrectAnnotationIntention
extends JSIntention {
    private static final JSElementPredicate PREDICATE = new FlowJsAnnotationPredicate();

    @Override
    @Nullable
    protected PsiElement findMatchingElement(@Nullable PsiElement element) {
        if (element != null && (element.getPrevSibling() instanceof PsiComment || element.getPrevSibling() instanceof JSDocTag)) {
            return element.getPrevSibling();
        }
        return super.findMatchingElement(element);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "isAvailable"));
        }
        if (!FlowJSAnnotation.isFlowAnnotation((PsiFile)element.getContainingFile()) && element.getParent().getLanguage() == JavaScriptSupportLoader.FLOW_JS) {
            return PREDICATE.satisfiedBy(element);
        }
        return false;
    }

    private PsiElement getSimpleComment(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "getSimpleComment"));
        }
        ASTNode node = JSChangeUtil.createJSTreeFromText((Project)project, (String)"// @flow", (JSLanguageDialect)JavaScriptSupportLoader.FLOW_JS);
        assert (node != null);
        return node.getPsi();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "processIntention"));
        }
        PsiElement currentElement = element;
        while (!(element.getParent() instanceof PsiFile)) {
            element = element.getParent();
        }
        PsiElement parent = element.getParent();
        PsiElement firstChild = parent.getFirstChild();
        parent.addBefore(this.getSimpleComment(element.getProject()), firstChild);
        PsiElement currentParent = currentElement.getParent();
        if (currentElement instanceof PsiCommentImpl) {
            this.updateComment((PsiComment)((PsiCommentImpl)element));
        } else if (currentParent instanceof JSDocComment || currentParent.getParent() instanceof JSDocComment) {
            if (currentParent.getParent() instanceof JSDocComment) {
                currentParent = currentParent.getParent();
            }
            this.updateComment((PsiComment)((JSDocComment)currentParent));
        }
    }

    @Nullable
    private PsiElement createNewComment(@NotNull Project project, @NotNull String newText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "createNewComment"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "createNewComment"));
        }
        ASTNode astNode = JSChangeUtil.createJSTreeFromText((Project)project, (String)newText, (JSLanguageDialect)JavaScriptSupportLoader.FLOW_JS);
        return astNode != null ? astNode.getPsi() : null;
    }

    private void updateComment(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "updateComment"));
        }
        String commentText = comment.getText();
        commentText = commentText.replace("@flow", "");
        if ((commentText = commentText.replaceAll("[/* \n]", "")).isEmpty()) {
            comment.delete();
        } else {
            String[] elements = comment.getText().split("\n");
            StringBuilder newElement = new StringBuilder();
            for (int i = 0; i < elements.length; ++i) {
                String element = elements[i];
                boolean isFlow = false;
                if (element.contains("@flow")) {
                    element = element.replace("@flow", "");
                    isFlow = true;
                }
                if (isFlow && element.replaceAll("[/* ]", "").isEmpty()) continue;
                newElement.append(element);
                if (i >= elements.length - 1) continue;
                newElement.append("\n");
            }
            PsiElement newComment = this.createNewComment(comment.getProject(), newElement.toString());
            if (newComment != null) {
                comment.replace(newComment);
            }
        }
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSCorrectAnnotationIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }
}

