/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.initialization.FlowJSVariablePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSTypeExplicitlyIntention
extends JSIntention {
    private static final JSElementPredicate PREDICATE = new FlowJSVariablePredicate();

    @Override
    @Nullable
    protected PsiElement findMatchingElement(@Nullable PsiElement element) {
        if (element != null && element.getParent() instanceof JSParameterList && element.getPrevSibling() instanceof JSParameter) {
            return element.getPrevSibling();
        }
        return super.findMatchingElement(element);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "isAvailable"));
        }
        if (FlowJSAnnotation.isFlowAnnotation((PsiFile)element.getContainingFile()) && (element.getLanguage() == JavaScriptSupportLoader.FLOW_JS || element.getParent().getLanguage() == JavaScriptSupportLoader.FLOW_JS)) {
            return PREDICATE.satisfiedBy(element);
        }
        return false;
    }

    private ASTNode getStatementWithType(@NotNull Project project, @NotNull String newTypeDeclaration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getStatementWithType"));
        }
        if (newTypeDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeDeclaration", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getStatementWithType"));
        }
        return JSChangeUtil.createStatementFromText((Project)project, (String)("var a: " + newTypeDeclaration), (JSLanguageDialect)JavaScriptSupportLoader.FLOW_JS);
    }

    @NotNull
    private PsiElement getColonPsiElement(@NotNull Project project, @NotNull String newTypeDeclaration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getColonPsiElement"));
        }
        if (newTypeDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeDeclaration", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getColonPsiElement"));
        }
        PsiElement psiElement = this.getStatementWithType(project, newTypeDeclaration).getLastChildNode().findChildByType(JSTokenTypes.COLON).getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getColonPsiElement"));
        }
        return psiElement;
    }

    @NotNull
    private PsiElement getParameterTypePsiElement(@NotNull Project project, @NotNull String newTypeDeclaration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getParameterTypePsiElement"));
        }
        if (newTypeDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeDeclaration", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getParameterTypePsiElement"));
        }
        PsiElement psiElement = this.getStatementWithType(project, newTypeDeclaration).getLastChildNode().getLastChildNode().getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getParameterTypePsiElement"));
        }
        return psiElement;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "processIntention"));
        }
        if (element instanceof JSParameter) {
            PsiFile containingFile = element.getContainingFile();
            if (element.getParent() instanceof JSParameterList) {
                String newTypeDeclaration = this.getTypeOfFunctions(element);
                if (!this.checkType(newTypeDeclaration)) {
                    return;
                }
                element.addAfter(this.getParameterTypePsiElement(containingFile.getProject(), newTypeDeclaration), element.getFirstChild());
                element.addAfter(this.getColonPsiElement(containingFile.getProject(), newTypeDeclaration), element.getFirstChild());
            }
        } else if (element.getParent() instanceof JSFunctionExpression || element.getParent() instanceof JSFunction) {
            Object expression = element.getParent() instanceof JSFunctionExpression ? (JSFunctionExpression)element.getParent() : (JSFunction)element.getParent();
            PsiFile containingFile = expression.getContainingFile();
            String newTypeDeclaration = this.getFunctionType(this.getTypeOfFunctions(element));
            JSParameterList parameterList = expression.getParameterList();
            if (!this.checkType(newTypeDeclaration) || parameterList == null) {
                return;
            }
            expression.addAfter(this.getParameterTypePsiElement(containingFile.getProject(), newTypeDeclaration), (PsiElement)parameterList);
            expression.addAfter(this.getColonPsiElement(containingFile.getProject(), newTypeDeclaration), (PsiElement)parameterList);
        } else if (element.getParent() instanceof JSVariable) {
            ASTNode newVariableStatement;
            JSVariable variable = (JSVariable)element.getParent();
            PsiFile containingFile = variable.getContainingFile();
            String newTypeDeclaration = this.getTypeOfFunctions(element.getParent());
            if (!this.checkType(newTypeDeclaration)) {
                return;
            }
            StringBuilder declarationBuffer = new StringBuilder();
            declarationBuffer.append("var ");
            declarationBuffer.append(variable.getName());
            declarationBuffer.append(":");
            declarationBuffer.append(newTypeDeclaration);
            JSExpression initializer = variable.getInitializer();
            if (initializer != null) {
                declarationBuffer.append("=");
                declarationBuffer.append(initializer.getText());
            }
            if ((newVariableStatement = JSChangeUtil.createStatementFromText((Project)containingFile.getProject(), (String)declarationBuffer.toString(), (JSLanguageDialect)JavaScriptSupportLoader.FLOW_JS)) == null) {
                return;
            }
            PsiElement psiElement = newVariableStatement.getPsi();
            JSVariable variableChild = (JSVariable)PsiTreeUtil.getChildOfType((PsiElement)psiElement, JSVariable.class);
            if (variableChild == null) {
                return;
            }
            variable.replace((PsiElement)variableChild);
            JSElementFactory.reformat((PsiElement)variableChild);
        }
    }

    private boolean checkType(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "checkType"));
        }
        return !type.isEmpty() && !type.equals("(unknown)");
    }

    @NotNull
    private String getTypeOfFunctions(PsiElement element) {
        VirtualFile virtualFile;
        if (ApplicationManager.getApplication().isUnitTestMode() && element.getContainingFile() != null) {
            PsiElement[] children = element.getContainingFile().getChildren();
            String string = children[2].getText().substring(2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getTypeOfFunctions"));
            }
            return string;
        }
        PsiFile containingFile = element.getContainingFile();
        FlowJSServerService service = FlowJSServerService.getService((Project)containingFile.getProject());
        FlowJSConfig config = service.getConfig(virtualFile = containingFile.getVirtualFile());
        if (config != null) {
            service.saveSyncAllUnsavedFiles();
            Document document = element.getContainingFile().getViewProvider().getDocument();
            if (document != null) {
                String string = service.getTypeOfElement(element, virtualFile, document, config);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getTypeOfFunctions"));
                }
                return string;
            }
        } else {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getTypeOfFunctions"));
            }
            return "";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getTypeOfFunctions"));
        }
        return "";
    }

    @NotNull
    private String getFunctionType(String serverType) {
        String[] array = serverType.split("=>");
        int numberOfOpenBracket = 0;
        StringBuilder functionType = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if ((numberOfOpenBracket = this.isCorrectBracketString(array[i], numberOfOpenBracket)) != 0) continue;
            for (int j = i + 1; j < array.length; ++j) {
                functionType.append(array[j]);
                if (j + 1 == array.length) continue;
                functionType.append("=>");
            }
            String string = functionType.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getFunctionType"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getFunctionType"));
        }
        return "";
    }

    private int isCorrectBracketString(@NotNull String string, int numberOfOpenBracketsBefore) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "isCorrectBracketString"));
        }
        for (int i = 0; i < string.length(); ++i) {
            char letter = string.charAt(i);
            if (letter == '(' || letter == '[' || letter == '{') {
                ++numberOfOpenBracketsBefore;
            }
            if (letter != ')' && letter != ']' && letter != '}') continue;
            --numberOfOpenBracketsBefore;
        }
        return numberOfOpenBracketsBefore;
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }
}

