/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8.value;

import com.intellij.util.Function;
import com.intellij.util.containers.IntIntHashMap;
import com.intellij.util.containers.UtilKt;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.GetObjectsResult;
import org.jetbrains.v8.protocol.Handle;
import org.jetbrains.v8.protocol.LookupMessage;
import org.jetbrains.v8.protocol.ObjectDescriptor;
import org.jetbrains.v8.protocol.PropertyDescriptor;
import org.jetbrains.v8.protocol.Protocol_exKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.SomeRef;
import org.jetbrains.v8.protocol.V8Request;
import org.jetbrains.v8.protocol.ValueHandle;
import org.jetbrains.v8.value.ArrayReference;
import org.jetbrains.v8.value.DataWithRef;
import org.jetbrains.v8.value.FunctionReference;
import org.jetbrains.v8.value.LoadableString;
import org.jetbrains.v8.value.ObjectReference;
import org.jetbrains.v8.value.PropertyItem;
import org.jetbrains.v8.value.V8Function;
import org.jetbrains.v8.value.V8Object;
import org.jetbrains.v8.value.V8PrimitiveValue;
import org.jetbrains.v8.value.V8ValueManager$WhenMappings;
import org.jetbrains.v8.value.V8ValueManagerKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u0016\u0010#\u001a\n $*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ/\u0010%\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 $*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f0\u001f0\u001b\u00a2\u0006\u0002\b&2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\u000e2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010!R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/v8/value/V8ValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "refToValue", "Lgnu/trove/TIntObjectHashMap;", "Lorg/jetbrains/debugger/values/Value;", "getVm", "()Lorg/jetbrains/v8/V8Vm;", "addHandleFromRefs", "handle", "Lorg/jetbrains/v8/protocol/Handle;", "clearCaches", "", "createValue", "objectDescriptor", "Lorg/jetbrains/v8/protocol/ObjectDescriptor;", "propertyDescriptor", "Lorg/jetbrains/v8/protocol/PropertyDescriptor;", "valueHandle", "Lorg/jetbrains/v8/protocol/ValueHandle;", "createValueIfSure", "refWithDisplayData", "Lorg/jetbrains/v8/protocol/SomeRef;", "doCreateValue", "getOrLoadValue", "Lorg/jetbrains/concurrency/Promise;", "id", "", "getOrLoadValueFromRefs", "", "propertyRefs", "", "Lorg/jetbrains/v8/value/PropertyItem;", "getValue", "kotlin.jvm.PlatformType", "loadValuesFromRemote", "Lorg/jetbrains/annotations/NotNull;", "propertyRefIds", "", "store", "objects", "v8-backend"})
public final class V8ValueManager
extends ValueManager {
    private final TIntObjectHashMap<Value> refToValue;
    @NotNull
    private final V8Vm vm;

    private final Value createValueIfSure(SomeRef refWithDisplayData) {
        String value;
        ValueType type;
        ValueType valueType;
        String className = refWithDisplayData.getClassName();
        String typeString = refWithDisplayData.getType();
        if (typeString == null && className == null) {
            valueType = null;
        } else {
            String string = typeString;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            valueType = type = V8ValueManagerKt.access$calculateType(string, className, false);
        }
        if (Intrinsics.areEqual((Object)type, (Object)ValueType.STRING)) {
            String possiblyTruncatedValue;
            String string = refWithDisplayData.getValue();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((possiblyTruncatedValue = string).length() > V8Request.Companion.getMAX_STRING_LENGTH()) {
                String pattern = "... (length: ";
                if (StringsKt.regionMatches$default((String)possiblyTruncatedValue, (int)V8Request.Companion.getMAX_STRING_LENGTH(), (String)pattern, (int)0, (int)pattern.length(), (boolean)false, (int)16, null)) {
                    int beginIndex = V8Request.Companion.getMAX_STRING_LENGTH() + pattern.length();
                    String string2 = possiblyTruncatedValue;
                    int n = StringsKt.indexOf$default((CharSequence)possiblyTruncatedValue, (char)')', (int)beginIndex, (boolean)false, (int)4, null);
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(beginIndex, n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int actualLength = Integer.parseInt(string4);
                    return (Value)new LoadableString(this, refWithDisplayData.getRef(), possiblyTruncatedValue, actualLength);
                }
                return null;
            }
        } else if (!V8ValueManagerKt.access$getTYPES_WITH_ACCURATE_DISPLAY$p().contains(type)) {
            return null;
        }
        if ((value = refWithDisplayData.getValue()) == null) {
            value = typeString;
        }
        int n = refWithDisplayData.getRef();
        ValueType valueType2 = type;
        if (valueType2 == null) {
            Intrinsics.throwNpe();
        }
        String string = value;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return (Value)new V8PrimitiveValue(n, valueType2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        TIntObjectHashMap<Value> tIntObjectHashMap = this.refToValue;
        synchronized (tIntObjectHashMap) {
            this.refToValue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final Value addHandleFromRefs(@NotNull Handle handle) {
        Intrinsics.checkParameterIsNotNull((Object)handle, (String)"handle");
        String type = handle.type();
        if (!Intrinsics.areEqual((Object)"script", (Object)type) && !Intrinsics.areEqual((Object)"context", (Object)type)) {
            ValueHandle valueHandle;
            if (handle instanceof ValueHandle) {
                valueHandle = (ValueHandle)handle;
            } else {
                Handle handle2 = handle;
                if (handle2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.v8.protocol.SomeHandle");
                }
                valueHandle = ((SomeHandle)handle2).asValueHandle();
            }
            return this.createValue(valueHandle);
        }
        return null;
    }

    private final Value doCreateValue(ValueHandle valueHandle) {
        String string = valueHandle.type();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"valueHandle.type()");
        ValueType type = V8ValueManagerKt.access$calculateType(string, valueHandle.className(), true);
        if (V8ValueManagerKt.access$getTYPES_WITH_ACCURATE_DISPLAY$p().contains(type)) {
            return (Value)new PrimitiveValue(type, valueHandle.value() == null ? valueHandle.type() : valueHandle.value());
        }
        if (Intrinsics.areEqual((Object)type, (Object)ValueType.STRING)) {
            int length = valueHandle.length();
            int toIndex = valueHandle.toIndex();
            if (length != -1 && toIndex != -1 && length != toIndex) {
                return (Value)new LoadableString(this, valueHandle.handle(), valueHandle.value(), length);
            }
            int n = valueHandle.handle();
            String string2 = valueHandle.value();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"valueHandle.value()");
            return (Value)new V8PrimitiveValue(n, type, string2);
        }
        return Intrinsics.areEqual((Object)type, (Object)ValueType.FUNCTION) ? (Value)new V8Function(valueHandle, this) : (Value)new V8Object(type, valueHandle, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Value createValue(@NotNull ValueHandle valueHandle) {
        void var4_4;
        Intrinsics.checkParameterIsNotNull((Object)valueHandle, (String)"valueHandle");
        TIntObjectHashMap<Value> tIntObjectHashMap = this.refToValue;
        synchronized (tIntObjectHashMap) {
            void var3_3;
            Value mirror = (Value)this.refToValue.get(valueHandle.handle());
            if (mirror == null) {
                mirror = this.doCreateValue(valueHandle);
                this.refToValue.put(valueHandle.handle(), (Object)mirror);
            }
            var4_4 = var3_3;
        }
        Value value = (Value)var4_4;
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"synchronized (refToValue\u2026     }\n      mirror\n    }");
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value createValue(@NotNull PropertyDescriptor propertyDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)propertyDescriptor, (String)"propertyDescriptor");
        if (propertyDescriptor.getObjectId() != -1) {
            Value value;
            TIntObjectHashMap<Value> tIntObjectHashMap = this.refToValue;
            synchronized (tIntObjectHashMap) {
                value = (Value)this.refToValue.get(propertyDescriptor.getObjectId());
            }
            return value;
        }
        ValueType valueType = ValueType.fromIndex((int)propertyDescriptor.getType());
        switch (V8ValueManager$WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()]) {
            case 1: {
                return (Value)PrimitiveValue.NULL;
            }
            case 2: {
                return (Value)PrimitiveValue.UNDEFINED;
            }
            case 3: {
                String string = propertyDescriptor.getValue();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return (Value)PrimitiveValue.bool((String)string);
            }
            case 4: 
            case 5: {
                String string = propertyDescriptor.getValue();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return (Value)new PrimitiveValue(valueType, string);
            }
        }
        throw (Throwable)new IllegalArgumentException(valueType.name());
    }

    private final Value createValue(ObjectDescriptor objectDescriptor) {
        ValueType valueType = ValueType.fromIndex((int)objectDescriptor.getType());
        switch (V8ValueManager$WhenMappings.$EnumSwitchMapping$1[valueType.ordinal()]) {
            case 1: {
                int length = objectDescriptor.getLength();
                String string = objectDescriptor.getDescription();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String value = string;
                if (length != -1 && length > value.length()) {
                    return (Value)new LoadableString(this, objectDescriptor.getId(), value, length);
                }
                int n = objectDescriptor.getId();
                ValueType valueType2 = valueType;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueType2, (String)"valueType");
                return (Value)new V8PrimitiveValue(n, valueType2, value);
            }
            case 2: {
                ValueType valueType3 = valueType;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueType3, (String)"valueType");
                return (Value)new ObjectReference(valueType3, objectDescriptor, this);
            }
            case 3: {
                return (Value)new FunctionReference(objectDescriptor, this);
            }
            case 4: {
                return (Value)new ArrayReference(objectDescriptor, this);
            }
        }
        throw (Throwable)new IllegalArgumentException(valueType.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value getValue(int id) {
        Value value;
        TIntObjectHashMap<Value> tIntObjectHashMap = this.refToValue;
        synchronized (tIntObjectHashMap) {
            value = (Value)this.refToValue.get(id);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Value> getOrLoadValue(int id) {
        Value value = this.getValue(id);
        if (value == null) {
            void obsolescent$iv;
            void $receiver$iv;
            Promise promise2 = this.vm.getCommandProcessor().send((Request)Protocol_exKt.GetObjects$default(id, 0, false, 6, null));
            Obsolescent obsolescent = (Obsolescent)this;
            return $receiver$iv.then((Function)new ObsolescentFunction<GetObjectsResult, Value>((Obsolescent)obsolescent$iv, this, id){
                final /* synthetic */ Obsolescent $obsolescent;
                final /* synthetic */ V8ValueManager this$0;
                final /* synthetic */ int $id$inlined;

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object fun(Object param) {
                    GetObjectsResult it = (GetObjectsResult)param;
                    this.this$0.store(it.objects());
                    return this.this$0.getValue(this.$id$inlined);
                }

                public boolean isObsolete() {
                    return this.$obsolescent.isObsolete();
                }
                {
                    this.$obsolescent = $captured_local_variable$1;
                    this.this$0 = v8ValueManager;
                    this.$id$inlined = n;
                }
            });
        }
        return Promises.resolvedPromise((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Value[]> getOrLoadValueFromRefs(@NotNull List<? extends PropertyItem> propertyRefs) {
        Intrinsics.checkParameterIsNotNull(propertyRefs, (String)"propertyRefs");
        Value[] result = new Value[propertyRefs.size()];
        if (propertyRefs.isEmpty()) {
            return Promises.resolvedPromise((Object)result);
        }
        IntIntHashMap refToRequestIndex = new IntIntHashMap();
        TIntArrayList needsLoading = null;
        int n = 0;
        int n2 = ((Collection)propertyRefs).size() - 1;
        if (n <= n2) {
            while (true) {
                SomeRef dataWithDisplayData;
                Value value;
                void i;
                PropertyItem property = propertyRefs.get((int)i);
                DataWithRef dataWithRef = property.getValueObject();
                int ref = dataWithRef.ref();
                TIntObjectHashMap<Value> tIntObjectHashMap = this.refToValue;
                synchronized (tIntObjectHashMap) {
                    value = (Value)this.refToValue.get(ref);
                }
                Value mirror = value;
                if (mirror == null && (dataWithDisplayData = dataWithRef.getWithDisplayData()) != null) {
                    mirror = this.createValueIfSure(dataWithDisplayData);
                }
                if (mirror == null) {
                    int requestPos = refToRequestIndex.get(ref);
                    if (requestPos == -1) {
                        if (needsLoading == null) {
                            needsLoading = new TIntArrayList();
                        }
                        refToRequestIndex.put(ref, needsLoading.size());
                        needsLoading.add(property.getRef());
                    }
                } else {
                    result[i] = mirror;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (needsLoading == null) {
            return Promises.resolvedPromise((Object)result);
        }
        int[] nArray = needsLoading.toNativeArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"needsLoading.toNativeArray()");
        Promise promise2 = this.loadValuesFromRemote(nArray).then((Function)new Function<Value[], Value[]>(propertyRefs, result, refToRequestIndex){
            final /* synthetic */ List $propertyRefs;
            final /* synthetic */ Value[] $result;
            final /* synthetic */ IntIntHashMap $refToRequestIndex;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Value[] fun(Value[] it) {
                int n = 0;
                int n2 = ((Collection)this.$propertyRefs).size() - 1;
                if (n <= n2) {
                    while (true) {
                        void i;
                        if (this.$result[i] == null) {
                            this.$result[i] = it[this.$refToRequestIndex.get(((PropertyItem)this.$propertyRefs.get((int)i)).getValueObject().ref())];
                        }
                        if (i == n2) break;
                        ++i;
                    }
                }
                if (this.$result == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.values.Value>");
                }
                return this.$result;
            }
            {
                this.$propertyRefs = list;
                this.$result = valueArray;
                this.$refToRequestIndex = intIntHashMap;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"loadValuesFromRemote(nee\u2026 as Array<Value>)\n      }");
        return promise2;
    }

    private final Promise<Value[]> loadValuesFromRemote(int[] propertyRefIds) {
        return this.vm.getCommandProcessor().send((Request)new LookupMessage(propertyRefIds, false, 0, 4, null)).then((Function)new Function<TIntObjectHashMap<ValueHandle>, Value[]>(this, propertyRefIds){
            final /* synthetic */ V8ValueManager this$0;
            final /* synthetic */ int[] $propertyRefIds;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Value[] fun(TIntObjectHashMap<ValueHandle> objects) {
                void var2_12;
                int size$iv = this.$propertyRefIds.length;
                Value[] result$iv = new Value[size$iv];
                int n = 0;
                int n2 = size$iv - 1;
                if (n <= n2) {
                    void i$iv;
                    do {
                        Value value;
                        ValueHandle valueHandle;
                        void it;
                        void var7_6 = ++i$iv;
                        void var13_10 = i$iv;
                        Value[] valueArray = result$iv;
                        int ref = this.$propertyRefIds[it];
                        if ((ValueHandle)objects.get(ref) == null) {
                            throw (Throwable)new IllegalStateException("Failed to find value for ref=" + ref);
                        }
                        if (valueHandle.handle() != ref) {
                            throw (Throwable)new IllegalStateException("Inconsistent ref in response, ref=" + ref);
                        }
                        valueArray[var13_10] = value = this.this$0.createValue(valueHandle);
                    } while (i$iv != n2);
                }
                Value[] result = (Value[])((Object[])result$iv);
                return var2_12;
            }
            {
                this.this$0 = v8ValueManager;
                this.$propertyRefIds = nArray;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(@Nullable List<? extends ObjectDescriptor> objects) {
        if (UtilKt.isNullOrEmpty(objects)) {
            return;
        }
        TIntObjectHashMap<Value> tIntObjectHashMap = this.refToValue;
        synchronized (tIntObjectHashMap) {
            List<? extends ObjectDescriptor> list = objects;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (ObjectDescriptor unit : list) {
                this.refToValue.put(unit.getId(), (Object)this.createValue(unit));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final V8Vm getVm() {
        return this.vm;
    }

    public V8ValueManager(@NotNull V8Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.refToValue = new TIntObjectHashMap();
    }
}

