/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.web;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.paths.PathReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author peter
 */
public interface CustomServletReferenceProvider {
  ExtensionPointName<CustomServletReferenceProvider> EXTENSION_POINT_NAME = ExtensionPointName.create("com.intellij.javaee.web.customServletReferenceProvider");

  @Nullable
  PathReference createWebPath(final String path, final @NotNull PsiElement element, final ServletMappingInfo info);

  /**
   * Create specific references if they are can be resolved/completed for given servlet.
   *
   * @param element underlying element.
   * @param info null if no servlet mapping found in the URL. The generated reference won't be resolved, but completion can be provided.
   * @param soft see {@link PsiReference#isSoft()}.
   * @return array of generated references.
   */
  @NotNull
  PsiReference[] createReferences(final @NotNull PsiElement element, final @Nullable ServletMappingInfo info, final boolean soft);

}
