/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

public interface DatabaseDialect {

  @NotNull
  DatabaseFamilyId getFamilyId();

  @NotNull
  Icon getIcon();

  @NotNull
  String getDisplayName();

  char closeQuote();

  char openQuote();

  @Nullable
  String getNameForKind(@NotNull ObjectKind kind);

  @Contract("null,_,_->null;!null,_,_->!null")
  String quoteIdentifier(String identifier, boolean force, boolean suppress);
  @Contract("null->null;!null->!null")
  String unquoteIdentifier(String identifier);
  @Contract("null->false")
  boolean isQuotedIdentifier(@Nullable String identifier);

  boolean supportsCorrelatedSubQuery();

  boolean supportsSubSecondTimestamps();

  @NotNull
  String getTypeName(DataType dataType);

  int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName);

  String getBinaryLiteralString(byte[] binaryData);

  boolean supportsSequence();

  boolean supportsTablespace();

  boolean supportsIndexes();

  boolean supportsAccessMethods();

  boolean supportsAutoIncrement();

  boolean supportsCheckOptionsForViews();

  boolean supportsEmptyTables();

  boolean supportsMultipleRowInserts();

  boolean supportsInsertInto();

  boolean supportsSequenceInformation();

  boolean supportsSchemasInTableDefinition();

  @NotNull
  String getNullColumnString();

  @NotNull
  String getMaxFunction();

  @NotNull
  String getLengthFunction();

  boolean supportsProduct(@Nullable String databaseProductName,
                          @NotNull String databaseProductVersion);

  boolean supportsColumnComment();

  boolean supportsColumnCommentsInTableDefinition();

  boolean supportsDropColumn();

  boolean supportsAlterColumnNull();

  boolean supportsAddPrimaryKey();

  boolean supportsRenameRoutine();

  boolean supportsRenameColumn();
  
  boolean supportsModifyColumn();

  boolean supportsAlterColumnType();

  boolean supportsAlterColumnDefault();

  boolean supportsDropPrimaryKey();

  boolean supportsDropForeignKey();

  boolean supportsCreateTable();

  @Nullable
  String[] getIndexAccessMethodsTypes();

  @Nullable
  String[] getIndexStorageOptions();


  boolean supportsRenameTable();

  boolean supportsCreateView();

  boolean supportsRenameView();

  boolean supportsDropView();

  boolean supportsDropProcedure();

  boolean supportsCreateIndex();

  boolean supportsDropIndex();

  boolean supportsCreateSequence();

  boolean supportsAlterSequence();

  boolean supportsDropSequence();

  boolean supportsAddForeignKey();

  boolean supportsAddUniqueConstraint();

  boolean supportsDropConstraint();

  boolean supportsAddColumn();

  boolean supportsViewDefinition();

  boolean supportsSystemViewDefinition();

  boolean supportsTableDefinition();

  boolean supportsTableInfo();

  boolean supportsProcedureDefinition();

  boolean supportsPackageDefinition();

  boolean supportsSequenceDefinition();

  boolean supportsSynonymDefinition();

  boolean supportsQualifiedAsteriskInCalls();

  boolean supportsCommonTableExpression();
}
