/**
 * Deprecated part of typescript compiler integration
 * Expands macros for 'output path' field
 */

let fileName = '$FileName$';
let fileDir = '$FileDir$';
let fileDirName = '$FileDirName$';
//relative to module content root
let fileDirRelativeToProjectRoot = '$FileDirRelativeToProjectRoot$';
let fileDirRelativeToSourcePath = '$FileDirRelativeToSourcepath$';
let fileRelativeDir = '$FileRelativeDir$';
let moduleFileDir = '$ModuleFileDir$';
let moduleSourcePath = '$ModuleFileDir$';
let sourcePath = '$Sourcepath$';

export type PathProcessor = { getExpandedPath(oldFileName: string, contentRoot, sourceRoot, onError)}

export function getPathProcessor(ts_impl, params: {projectPath?: string, outPath?: string}):PathProcessor {
    let projectPath = ts_impl.normalizePath(params.projectPath);
    let outPath = ts_impl.normalizePath(params.outPath);
    let outPathHasMacro = outPath.indexOf('$') >= 0;

    let separator = '/';

    /**
     * @param {string} path
     */
    function isAbsolute(path) {
        return path.indexOf('/') === 0 || path.indexOf(':') > 0;
    }


    function getName(oldFileName) {
        return oldFileName.substring(oldFileName.lastIndexOf(separator) + 1);
    }

    class MacroProcessor {

        getExpandedPath(oldFileName: string, contentRoot, sourceRoot, onError):string {
            try {
                oldFileName = ts_impl.normalizePath(oldFileName);
                //oldFileName is absolute normalized path
                let newFileName = getName(oldFileName);

                let partWithoutName = outPath;
                if (outPathHasMacro) {
                    partWithoutName = this.expandMacro(oldFileName, newFileName, contentRoot, sourceRoot);
                }

                let path = "";
                if (partWithoutName) {
                    path += partWithoutName + '/';
                }
                path += newFileName;

                if (!isAbsolute(path)) {
                    path = projectPath + '/' + path;
                }

                console.log('suggested path is ' + path);
                return path;
            }
            catch (e) {
                console.log('Suggester error ' + e);
                onError(e);
            }

            return null;
        };


        private expandMacro(fullFileName: string, onlyFileName: string, contentRoot?: string, sourceRoot?: string) {
            let expandValue = outPath;

            function hasMacro(m) {
                return expandValue.indexOf(m) >= 0;
            }

            function expand(m, value) {
                expandValue = expandValue.replace(m, value)
            }


            if (hasMacro(fileName)) {
                expand(fileName, onlyFileName);
            }

            if (hasMacro(fileDir)) {
                expand(fileDir, ts_impl.getDirectoryPath(fullFileName));
            }

            if (hasMacro(fileDirName)) {
                expand(fileDirName, getName(ts_impl.getDirectoryPath(fullFileName)))
            }

            if (hasMacro(fileRelativeDir)) {
                expand(fileRelativeDir, ts_impl.getDirectoryPath(fullFileName.replace(projectPath + separator, "")));
            }

            if (hasMacro(fileDirRelativeToProjectRoot)) {
                expand(fileDirRelativeToProjectRoot, ts_impl.getDirectoryPath(fullFileName.replace(ts_impl.normalizePath(contentRoot) + separator, "")));
            }

            if (hasMacro(fileDirRelativeToSourcePath)) {
                expand(fileDirRelativeToSourcePath, ts_impl.getDirectoryPath(fullFileName.replace(ts_impl.normalizePath(sourceRoot) + separator, "")));
            }

            if (hasMacro(moduleFileDir)) {
                expand(moduleFileDir, ts_impl.normalizePath(contentRoot));
            }

            if (hasMacro(moduleSourcePath)) {
                expand(moduleSourcePath, ts_impl.normalizePath(sourceRoot));
            }

            if (hasMacro(sourcePath)) {
                expand(sourcePath, ts_impl.normalizePath(sourceRoot));
            }

            return expandValue;
        }
    }

    return new MacroProcessor();
}