/// <reference path="protocol.d.ts" />
/// <reference path="editorServices.d.ts" />
declare namespace ts.server {
    function generateSpaces(n: number): string;
    function generateIndentString(n: number, editorOptions: EditorOptions): string;
    interface PendingErrorCheck {
        fileName: string;
        project: Project;
    }
    namespace CommandNames {
        const Brace: string;
        const Change: string;
        const Close: string;
        const Completions: string;
        const CompletionDetails: string;
        const Configure: string;
        const Definition: string;
        const Exit: string;
        const Format: string;
        const Formatonkey: string;
        const Geterr: string;
        const GeterrForProject: string;
        const NavBar: string;
        const Navto: string;
        const Occurrences: string;
        const DocumentHighlights: string;
        const Open: string;
        const Quickinfo: string;
        const References: string;
        const Reload: string;
        const Rename: string;
        const Saveto: string;
        const SignatureHelp: string;
        const TypeDefinition: string;
        const ProjectInfo: string;
        const ReloadProjects: string;
        const Unknown: string;
    }
    interface ServerHost extends ts.System {
    }
    class Session {
        private host;
        private byteLength;
        private hrtime;
        private logger;
        protected projectService: ProjectService;
        private errorTimer;
        private immediateId;
        private changeSeq;
        constructor(host: ServerHost, byteLength: (buf: string, encoding?: string) => number, hrtime: (start?: number[]) => number[], logger: Logger);
        private handleEvent(eventName, project, fileName);
        logError(err: Error, cmd: string): void;
        private sendLineToClient(line);
        send(msg: protocol.Message): void;
        event(info: any, eventName: string): void;
        private response(info, cmdName, reqSeq?, errorMsg?);
        output(body: any, commandName: string, requestSequence?: number, errorMessage?: string): void;
        private semanticCheck(file, project);
        private syntacticCheck(file, project);
        private reloadProjects();
        private updateProjectStructure(seq, matchSeq, ms?);
        private updateErrorCheck(checkList, seq, matchSeq, ms?, followMs?, requireOpen?);
        private getDefinition(line, offset, fileName);
        private getTypeDefinition(line, offset, fileName);
        private getOccurrences(line, offset, fileName);
        private getDocumentHighlights(line, offset, fileName, filesToSearch);
        private getProjectInfo(fileName, needFileNameList);
        private getRenameLocations(line, offset, fileName, findInComments, findInStrings);
        private getReferences(line, offset, fileName);
        private openClientFile(fileName, fileContent?);
        private getQuickInfo(line, offset, fileName);
        private getFormattingEditsForRange(line, offset, endLine, endOffset, fileName);
        private getFormattingEditsAfterKeystroke(line, offset, key, fileName);
        private getCompletions(line, offset, prefix, fileName);
        private getCompletionEntryDetails(line, offset, entryNames, fileName);
        private getSignatureHelpItems(line, offset, fileName);
        private getDiagnostics(delay, fileNames);
        private change(line, offset, endLine, endOffset, insertString, fileName);
        private reload(fileName, tempFileName, reqSeq?);
        private saveToTmp(fileName, tempFileName);
        private closeClientFile(fileName);
        private decorateNavigationBarItem(project, fileName, items);
        private getNavigationBarItems(fileName);
        private getNavigateToItems(searchValue, fileName, maxResultCount?);
        private getBraceMatching(line, offset, fileName);
        getDiagnosticsForProject(delay: number, fileName: string): void;
        getCanonicalFileName(fileName: string): string;
        exit(): void;
        private handlers;
        addProtocolHandler(command: string, handler: (request: protocol.Request) => {
            response?: any;
            responseRequired: boolean;
        }): void;
        executeCommand(request: protocol.Request): {
            response?: any;
            responseRequired?: boolean;
        };
        onMessage(message: string): void;
    }
}
